/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.support;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.systemdynamics.translator.InformationManagers;

public class ArrayReference {
    private String arrayName;
    private List<String> subscripts;

    public ArrayReference(String reference) {
        this.arrayName = this.extractArrayName(reference);
        this.subscripts = this.extractSubscripts(reference);
    }

    public String getVensimReference() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.arrayName);
        sb.append("[");
        int i = 0;
        for (String s : this.subscripts) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        sb.append("]");
        return sb.toString();
    }

    public String generateLHSHeader(String valueVariable) {
        StringBuffer code = new StringBuffer();
        code.append("for (SubscriptCombination outerSub : getSubscriptValueCombinations(");
        int s = 0;
        for (String sub : this.subscripts) {
            if (s++ > 0) {
                code.append(",");
            }
            code.append("\"" + sub + "\"");
        }
        code.append(")) {\n");
        return code.toString();
    }

    public boolean hasRangeSubscript() {
        for (String sub : this.subscripts) {
            if (!ArrayReference.isRangeSubscript(sub)) continue;
            return true;
        }
        return false;
    }

    public String generateLHSFooter(String valueVariable) {
        StringBuffer code = new StringBuffer();
        code.append("arraySetValue(\"" + this.arrayName + "\", outerSub.getSubscriptValue(), " + valueVariable + ");\n");
        code.append("}\n");
        return code.toString();
    }

    public String generateRHSImplementation() {
        StringBuffer code = new StringBuffer();
        code.append("arrayValueOf(\"" + this.arrayName + "\",concatAsSubscript(");
        int subNum = 0;
        for (String sub : this.subscripts) {
            if (subNum++ > 0) {
                code.append(",");
            }
            if (ArrayReference.isRangeSubscript(sub)) {
                code.append("rangeSub.getSubscriptValue(\"" + sub.replace("!", "") + "\")");
                continue;
            }
            if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(sub)) {
                code.append("outerSub.getSubscriptValue(\"" + sub.replace("!", "") + "\")");
                continue;
            }
            code.append("\"" + sub.replace("!", "") + "\"");
        }
        code.append("))");
        return code.toString();
    }

    public String generateRHSName() {
        StringBuffer code = new StringBuffer();
        code.append("\"" + this.arrayName + "[\"+concatAsSubscript(");
        int subNum = 0;
        for (String sub : this.subscripts) {
            if (subNum++ > 0) {
                code.append(",");
            }
            if (ArrayReference.isRangeSubscript(sub)) {
                code.append("rangeSub.getSubscriptValue(\"" + sub.replace("!", "") + "\")");
                continue;
            }
            if (InformationManagers.getInstance().getNamedSubscriptManager().isNamedSubscript(sub)) {
                code.append("outerSub.getSubscriptValue(\"" + sub.replace("!", "") + "\")");
                continue;
            }
            code.append("\"" + sub.replace("!", "") + "\"");
        }
        code.append("+\"]\")");
        return code.toString();
    }

    public static boolean isArrayReference(String token) {
        if (token.startsWith("\"array.") && token.endsWith("\"") || token.startsWith("stringConcat(\"memory.") && token.endsWith("\")")) {
            return false;
        }
        return (token.startsWith("array.") || token.startsWith("lookup.")) && token.contains("[") && token.contains("]") || token.contains("[") && token.contains("]");
    }

    public static boolean isRangeSubscript(String subscript) {
        return subscript.endsWith("!");
    }

    private String extractArrayName(String reference) {
        return reference.split("\\[")[0].replace("array.", "").replace("lookup.", "").trim();
    }

    private List<String> extractSubscripts(String reference) {
        String[] verify = reference.split("\\[");
        if (verify.length < 2) {
            System.out.println("ArrayReference: bad extractSubscripts: " + reference);
        }
        ArrayList<String> subscripts = new ArrayList<String>();
        String[] stringArray = reference.split("\\[")[1].split("]")[0].split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sub = stringArray[n2];
            subscripts.add(sub.trim());
            ++n2;
        }
        return subscripts;
    }

    public String[] getNonRangeSubscriptsAsArray() {
        List<String> al = this.getNonRangeSubscripts();
        return al.toArray(new String[al.size()]);
    }

    public List<String> getNonRangeSubscripts() {
        ArrayList<String> ranges = new ArrayList<String>();
        for (String sub : this.subscripts) {
            if (sub.contains("!")) continue;
            ranges.add(sub);
        }
        return ranges;
    }

    public String[] getRangeSubscriptsAsArray() {
        List<String> al = this.getRangeSubscripts();
        return al.toArray(new String[al.size()]);
    }

    public List<String> getRangeSubscripts() {
        ArrayList<String> ranges = new ArrayList<String>();
        for (String sub : this.subscripts) {
            if (!sub.contains("!")) continue;
            ranges.add(sub);
        }
        return ranges;
    }

    public List<String> getRangeSubscriptsWithDimension() {
        ArrayList<String> ranges = new ArrayList<String>();
        int dim = 0;
        for (String sub : this.subscripts) {
            if (!sub.contains("!")) continue;
            ranges.add(String.valueOf(sub.replace("!", "")) + "###" + dim);
        }
        ++dim;
        return ranges;
    }

    public String[] getRangeSubscriptsNamesAsArray() {
        List<String> al = this.getRangeSubscriptsNames();
        return al.toArray(new String[al.size()]);
    }

    public List<String> getRangeSubscriptsNames() {
        ArrayList<String> ranges = new ArrayList<String>();
        for (String sub : this.subscripts) {
            if (!sub.contains("!")) continue;
            ranges.add(sub.replace("[", "").replace("]", "").replace("!", ""));
        }
        return ranges;
    }

    public List<String> getUniqueRangeSubscriptsNames() {
        ArrayList<String> ranges = new ArrayList<String>();
        for (String sub : this.subscripts) {
            String newSub;
            if (!sub.contains("!") || ranges.contains(newSub = sub.replace("[", "").replace("]", "").replace("!", ""))) continue;
            ranges.add(newSub);
        }
        return ranges;
    }

    public String getSubscriptsAsMethodParameters() {
        StringBuffer sb = new StringBuffer();
        for (String sub : this.subscripts) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("\"" + sub + "\"");
        }
        return sb.toString();
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public List<String> getSubscripts() {
        return this.subscripts;
    }

    public String[] getSubscriptsAsArray() {
        String[] s = new String[this.subscripts.size()];
        int i = 0;
        for (String sub : this.subscripts) {
            s[i++] = sub;
        }
        return s;
    }

    public void setSubscripts(List<String> subscripts) {
        this.subscripts = subscripts;
    }

    public String getSubscript() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (String s : this.subscripts) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

