/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.ode;

import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.commons.lang.WordUtils;
import repast.simphony.systemdynamics.ode.ODEAnalyzer;
import repast.simphony.systemdynamics.ode.ODECodeGenerator;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.NativeDataTypeManager;

public class SetterGetter {
    public static void generate(ODECodeGenerator odeCG, BufferedWriter code, ODEAnalyzer analyzer) {
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        for (Equation eqn : analyzer.getAuxiliariesForConstructor()) {
            SetterGetter.generateGetter(code, ndtm.makeLegal(eqn.getLhs()));
            SetterGetter.generateSetter(code, ndtm.makeLegal(eqn.getLhs()));
        }
    }

    public static void generateGetter(BufferedWriter code, String var) {
        String captitalized = WordUtils.capitalize((String)var);
        try {
            code.append("\tpublic double get" + captitalized + "() {\n");
            code.append("\t\treturn " + var + ";\n");
            code.append("\t}\n\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateSetter(BufferedWriter code, String var) {
        String captitalized = WordUtils.capitalize((String)var);
        try {
            code.append("\tpublic void set" + captitalized + "(double value) {\n");
            code.append("\t\t" + var + " = value;\n");
            code.append("\t}\n\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

