/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.ode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.systemdynamics.sdmodel.VariableType;
import repast.simphony.systemdynamics.support.MutableInteger;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.NativeDataTypeManager;

public class ODEAnalyzer {
    private Map<String, String> stockToIndex;
    private Map<String, String> indexToStock;
    private List<Equation> auxiliaries;
    private Map<String, Equation> equations;
    List<String> orderedEquations;

    public ODEAnalyzer(Map<String, Equation> equations, List<String> orderedEquations) {
        this.equations = equations;
        this.stockToIndex = new HashMap<String, String>();
        this.indexToStock = new HashMap<String, String>();
        this.auxiliaries = new ArrayList<Equation>();
        this.orderedEquations = orderedEquations;
    }

    public void analyze() {
        this.analyzeStocks();
        this.analyzeAuxiliaries();
    }

    public List<Equation> getEquationIterator() {
        ArrayList<Equation> eqns = new ArrayList<Equation>();
        for (String lhs : this.orderedEquations) {
            eqns.add(this.equations.get(lhs));
        }
        return eqns;
    }

    private void print() {
        for (String s : this.stockToIndex.keySet()) {
            System.out.println("Stock: " + s);
        }
        for (Equation eqn : this.auxiliaries) {
            System.out.println("aux: " + eqn.getLhs());
        }
    }

    private void analyzeStocks() {
        MutableInteger index = new MutableInteger(0);
        for (Equation eqn : this.equations.values()) {
            String var;
            if (!eqn.isStock() || this.stockToIndex.containsKey(var = eqn.getLhs())) continue;
            this.stockToIndex.put(var, index.toString());
            this.indexToStock.put(index.toString(), var);
            index.add(1);
        }
    }

    public int getNumberODE() {
        return this.stockToIndex.size();
    }

    public String getIndexFor(String stockVar) {
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        String original = ndtm.getOriginalName(stockVar);
        return this.stockToIndex.get(original);
    }

    public String getStockFor(String index) {
        return this.indexToStock.get(index);
    }

    private void analyzeAuxiliaries() {
        for (Equation eqn : this.equations.values()) {
            if (!eqn.getVariableType().equals((Object)VariableType.AUXILIARY) && !eqn.getVariableType().equals((Object)VariableType.CONSTANT) && !eqn.getVariableType().equals((Object)VariableType.RATE) || eqn.isAutoGenerated()) continue;
            this.auxiliaries.add(eqn);
        }
    }

    public boolean isStock(String var) {
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        String original = ndtm.getOriginalName(var);
        return this.stockToIndex.containsKey(original);
    }

    public boolean isAuxiliary(String var) {
        return this.auxiliaries.contains(var);
    }

    public List<Equation> getAuxiliariesForConstructor() {
        ArrayList<Equation> al = new ArrayList<Equation>();
        for (Equation eqn : this.auxiliaries) {
            if (!eqn.isOneTime()) continue;
            al.add(eqn);
        }
        return al;
    }

    public List<Equation> getAuxiliariesForMethodBody() {
        ArrayList<Equation> al = new ArrayList<Equation>();
        for (Equation eqn : this.auxiliaries) {
            if (eqn.isOneTime()) continue;
            al.add(eqn);
        }
        return al;
    }

    public List<Equation> getAuxiliaries() {
        return this.auxiliaries;
    }

    public Map<String, Equation> getEquations() {
        return this.equations;
    }

    public Equation getEquationForLHS(String s) {
        return this.equations.get(s);
    }
}

