/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.ode;

import java.io.BufferedWriter;
import java.io.IOException;
import repast.simphony.systemdynamics.ode.ODEAnalyzer;
import repast.simphony.systemdynamics.ode.ODECodeGenerator;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.NativeDataTypeManager;

public class Constructor {
    public static void generate(ODECodeGenerator odeCG, BufferedWriter code, ODEAnalyzer analyzer, String packageName, String className) {
        NativeDataTypeManager ndtm = InformationManagers.getInstance().getNativeDataTypeManager();
        try {
            for (Equation eqn : analyzer.getAuxiliaries()) {
                if (eqn.isOneTime()) {
                    code.append("\tprivate double " + ndtm.makeLegal(eqn.getLhs()) + " = " + eqn.getRhs() + ";\n");
                    continue;
                }
                code.append("\tprivate double " + ndtm.makeLegal(eqn.getLhs()) + ";\n");
            }
            code.append("\tprivate ODEFunctionSupport sdFunctions = new ODEFunctionSupport();\n\n");
            code.append("\n\tpublic " + className + "() {\n\t}");
            if (analyzer.getAuxiliariesForConstructor().size() > 0) {
                code.append("\n\tpublic " + className + "(");
                int i = 0;
                for (Equation eqn : analyzer.getAuxiliariesForConstructor()) {
                    if (i++ > 0) {
                        code.append(", ");
                    }
                    code.append("double " + ndtm.makeLegal(eqn.getLhs()));
                }
                code.append(") {\n\n");
                for (Equation eqn : analyzer.getAuxiliariesForConstructor()) {
                    code.append("\tthis." + ndtm.makeLegal(eqn.getLhs()) + " = " + ndtm.makeLegal(eqn.getLhs()) + ";\n");
                }
                code.append("\t}\n\n");
            }
            code.append("\t public int getDimension() {\n\t\treturn " + analyzer.getNumberODE() + ";\n\t}\n\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

