/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.engine;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import repast.simphony.systemdynamics.engine.Response;
import repast.simphony.systemdynamics.sdmodel.SDModelFactory;
import repast.simphony.systemdynamics.sdmodel.SDModelPackage;
import repast.simphony.systemdynamics.sdmodel.SystemModel;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.MDLToSystemModel;
import repast.simphony.systemdynamics.translator.SystemDynamicsObjectManager;
import repast.simphony.systemdynamics.translator.TranslatorRepastSimphony;

public class Engine {
    private static final String EPIDEMIC_MDL = "./test_data/EPIDEMIC.MDL";
    private static final String WFINV_MDL = "./test_data/WFINV.MDL";
    private static final String ARMS_MDL = "./test_data/arms4.mdl";
    private List<String> messages = new ArrayList<String>();
    private String currentModel;
    private TranslatorRepastSimphony translator;
    private IProject project;
    private IProgressMonitor progressMonitor;
    private SystemModel model;
    private Diagram diagram;

    public TranslatorRepastSimphony getTranslator() {
        return this.translator;
    }

    public Engine() {
        InformationManagers.getInstance();
        this.translator = new TranslatorRepastSimphony(this);
        System.out.println("Engine created");
    }

    public Engine(SystemModel systemModel, IProject project, IProgressMonitor progressMonitor, boolean hybridCompatibility) {
        this();
        this.project = project;
        this.progressMonitor = progressMonitor;
        this.translator = new TranslatorRepastSimphony(project, progressMonitor, this);
        this.translator.setHybridCompatibility(hybridCompatibility);
        InformationManagers.clear();
        InformationManagers.getInstance().setSystemModel(systemModel);
        Equation.initializeCounts();
    }

    public void generateCodeForRSD(SystemModel systemModel) {
        this.getTranslator().generateCodeForRSD(systemModel);
    }

    public SystemModel validateGenerateSystemModel(String mdlFile, boolean generateCode) {
        this.model = SDModelFactory.eINSTANCE.createSystemModel();
        this.model.setClassName("ClassName");
        this.model.setPackage("aPackageName");
        this.model.setStartTime(0.0);
        this.model.setEndTime(0.0);
        this.model.setTimeStep(0.125);
        this.model.setReportingInterval(1.0);
        this.model.setUnits("units");
        this.diagram = NotationFactory.eINSTANCE.createDiagram();
        if (this.diagram != null) {
            this.diagram.setName("test.rsd");
            this.diagram.setElement((EObject)this.model);
        }
        System.out.println("############# MDLToSystemModel Start");
        System.out.println("############# MDLToSystemModel Start");
        System.out.println("############# MDLToSystemModel Start");
        System.out.println("############# MDLToSystemModel Start");
        System.out.println("############# MDLToSystemModel Start");
        MDLToSystemModel trans = new MDLToSystemModel();
        trans.run(this.model, this.diagram, mdlFile);
        System.out.println("############# MDLToSystemModel End");
        System.out.println("############# MDLToSystemModel End");
        System.out.println("############# MDLToSystemModel End");
        System.out.println("############# MDLToSystemModel End");
        System.out.println("############# MDLToSystemModel End");
        boolean result = true;
        if (result) {
            this.messages.add("Model syntax OK\n");
            this.messages.add("Model units consistent\n");
            if (generateCode) {
                this.messages.add("Java source code generated");
            }
        }
        InformationManagers.getInstance().getMessageManager().addToMessages(this.messages);
        return this.model;
    }

    public boolean validateGenerateRSD(SystemModel systemModel, boolean generateCode) {
        boolean result = this.getTranslator().validateGenerateRSD(systemModel, generateCode, this.messages);
        if (result) {
            this.messages.add("Model syntax OK\n");
            this.messages.add("Model units consistent\n");
            if (generateCode) {
                this.messages.add("Java source code generated");
            }
        }
        InformationManagers.getInstance().getMessageManager().addToMessages(this.messages);
        return result;
    }

    public boolean validateGenerateMDL(String mdlFile, boolean generateCode) {
        System.out.println("vg MDL: " + mdlFile);
        boolean result = this.getTranslator().validateGenerateMDL(mdlFile, generateCode, this.messages);
        if (result) {
            this.messages.add("Model syntax OK\n");
            this.messages.add("Model units consistent\n");
            if (generateCode) {
                this.messages.add("Java source code generated");
            }
        }
        InformationManagers.getInstance().getMessageManager().addToMessages(this.messages);
        return result;
    }

    public SystemModel loadMDL(String filename) {
        return null;
    }

    public static void main(String[] args) {
    }

    public Response modelName(String modelName) {
        return new Response();
    }

    public Response variable(String variableName, String type, String equationRHS, String units, String comment) {
        return new Response();
    }

    public Response equation(String variableName, String equation) {
        return new Response();
    }

    public Response type(String variableName, String type) {
        return new Response();
    }

    public Response units(String variableName, String units) {
        return new Response();
    }

    public Response comment(String variableName, String comment) {
        return new Response();
    }

    public Response checkSyntax(String equation) {
        return new Response();
    }

    public Response checkSyntaxForVariable(String variableName) {
        return new Response();
    }

    public Response validateUnits() {
        return new Response();
    }

    public Response setModelParameters(String startTime, String endTime, String timeStep, String savper) {
        return new Response();
    }

    public Response defineSubscript(String subrDefinition) {
        return new Response();
    }

    public Response defineUnitsEquivalance(String unitsEquivalence) {
        return new Response();
    }

    public Response loadVensimModel(String filename) {
        return new Response();
    }

    public SystemModel loadRSModel(String filename) {
        SystemModel systemModel = null;
        try {
            XMIResourceImpl resource = new XMIResourceImpl();
            resource.load((InputStream)new FileInputStream(filename), new HashMap());
            for (EObject obj : resource.getContents()) {
                if (!obj.eClass().equals(SDModelPackage.Literals.SYSTEM_MODEL)) continue;
                systemModel = (SystemModel)obj;
                return systemModel;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Response generateCode(String directory) {
        return new Response();
    }

    public Response getFunctionCategories() {
        return new Response();
    }

    public Response getFunctions(String category) {
        return new Response();
    }

    public Response registerUserFunction(String object, String name, String[] args, String[] argTypes, String[] argUnits, String returnType, String returnUnits) {
        return new Response();
    }

    public Response getLookupTableDefinitionSyntax() {
        return new Response();
    }

    public Response getSubscriptDefinitionSyntax() {
        StringBuffer sb = new StringBuffer();
        sb.append("Subscript Definition Syntax\n");
        sb.append("NamedSubscript : sub1, sub2, ..., subN\n");
        sb.append("where subn is another named subscript or a terminal value\n\n");
        sb.append("NamedSubscript : (sub1-sub4)\n");
        sb.append("is equivalent to:\n");
        sb.append("NamedSubscript : sub1, sun2, sub3, sub4\n");
        Response response = new Response();
        response.setMessage(sb.toString());
        return response;
    }

    public Response getEquivalenceDefinitionSyntax() {
        return new Response();
    }

    public Response getReservedWords() {
        return new Response();
    }

    public Response getOperators() {
        return new Response();
    }

    public SystemDynamicsObjectManager getSdObjectManager() {
        return this.translator.getSdObjectManager();
    }

    public String getMessages() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.messages) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }
}

