/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.systemdynamics.analysis;

import java.util.HashMap;
import java.util.Map;
import repast.simphony.systemdynamics.translator.Equation;
import repast.simphony.systemdynamics.translator.InformationManagers;
import repast.simphony.systemdynamics.translator.Node;

public class PolarityCodeBuilder {
    private Equation equation;
    private Map<String, String> idToNameMap;
    private Node polarityRoot;
    private String generatedCode;

    public PolarityCodeBuilder(Equation equation) {
        this.equation = equation;
        this.idToNameMap = new HashMap<String, String>();
        this.polarityRoot = equation.getCopyOfTree();
        this.insertIDs();
        this.generatedCode = new String(this.build());
    }

    private void insertIDs() {
        Node lhs = this.polarityRoot.getChild();
        String lhsVar = "lhs";
        this.idToNameMap.put(lhsVar, lhs.getToken());
        lhs.setToken(lhsVar);
        int id = 0;
        for (String variable : this.equation.getRHSVariables()) {
            this.replaceVariableWithID(this.polarityRoot, InformationManagers.getInstance().getNativeDataTypeManager().getLegalNameWithSubscripts(this.equation, variable), id);
            this.replaceVariableWithID(this.polarityRoot, variable, id);
            ++id;
        }
    }

    private void replaceVariableWithID(Node node, String variable, int id) {
        if (node == null) {
            return;
        }
        if (node.getToken().equals(variable)) {
            String rhsVar = "rhs[" + id + "]";
            node.setToken(rhsVar);
            this.idToNameMap.put(rhsVar, variable);
        }
        this.replaceVariableWithID(node.getChild(), variable, id);
        this.replaceVariableWithID(node.getNext(), variable, id);
    }

    public String build() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.equation.getEquationFromTree(this.polarityRoot));
        return sb.toString();
    }

    public String getGeneratedCode() {
        return this.generatedCode;
    }
}

