/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts.old;

import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.statecharts.old.Transition;

public class TimedTransition
implements Transition {
    private final double time;
    private ISchedulableAction currentScheduledAction;
    private boolean triggered = false;

    public TimedTransition(double time) {
        this.time = time;
    }

    @Override
    public boolean isTriggered() {
        return this.triggered;
    }

    public void initializeTrigger() {
        this.triggered = false;
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        double currentTickCount = schedule.getTickCount();
        schedule.removeAction(this.currentScheduledAction);
        this.currentScheduledAction = schedule.schedule(ScheduleParameters.createOneTime((double)(currentTickCount + this.time)), (Object)this, "trigger", new Object[0]);
    }

    public void trigger() {
        this.triggered = true;
    }

    public void deactivateTrigger() {
        if (this.currentScheduledAction != null) {
            ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
            schedule.removeAction(this.currentScheduledAction);
        }
    }
}

