/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import repast.simphony.parameter.Parameters;
import repast.simphony.statecharts.AbstractState;
import repast.simphony.statecharts.AlwaysTrigger;
import repast.simphony.statecharts.GuardCondition;
import repast.simphony.statecharts.Transition;
import repast.simphony.statecharts.TransitionAction;
import repast.simphony.statecharts.Trigger;

public class TransitionBuilder<T> {
    private Trigger trigger;
    private AbstractState<T> source;
    private AbstractState<T> target;
    private double priority = 0.0;
    private TransitionAction<T> onTransition = new EmptyOnTransition<T>();
    private GuardCondition<T> guard = new EmptyGuard<T>();
    private String id;

    public static <U> GuardCondition<U> createEmptyGuard() {
        return new EmptyGuard();
    }

    public static <U> TransitionAction<U> createEmptyOnTransition() {
        return new EmptyOnTransition();
    }

    public TransitionBuilder(String id, AbstractState<T> source, AbstractState<T> target) {
        this.id = id;
        this.source = source;
        this.target = target;
    }

    public TransitionBuilder(AbstractState<T> source, AbstractState<T> target) {
        this("", source, target);
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public void addTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public void registerOnTransition(TransitionAction<T> onTransition) {
        this.onTransition = onTransition;
    }

    public void registerGuard(GuardCondition<T> guard) {
        this.guard = guard;
    }

    public Transition<T> build() {
        if (this.trigger == null) {
            this.trigger = new AlwaysTrigger();
        }
        if (this.source == null) {
            throw new IllegalStateException("The source state must be specified to build a transition.");
        }
        if (this.target == null) {
            throw new IllegalStateException("The target state must be specified to build a transition.");
        }
        Transition<T> result = new Transition<T>(this.id, this.trigger, this.source, this.target, this.priority);
        result.registerGuard(this.guard);
        result.registerOnTransition(this.onTransition);
        return result;
    }

    private static class EmptyGuard<U>
    implements GuardCondition<U> {
        private EmptyGuard() {
        }

        @Override
        public boolean condition(U agent, Transition<U> transition, Parameters params) throws Exception {
            return true;
        }
    }

    private static class EmptyOnTransition<U>
    implements TransitionAction<U> {
        private EmptyOnTransition() {
        }

        @Override
        public void action(U agent, Transition<U> transition, Parameters params) throws Exception {
        }
    }
}

