/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import java.util.Queue;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.parameter.Parameters;
import repast.simphony.statecharts.AbstractState;
import repast.simphony.statecharts.AbstractTrigger;
import repast.simphony.statecharts.DefaultStateChart;
import repast.simphony.statecharts.GuardCondition;
import repast.simphony.statecharts.TransitionAction;
import repast.simphony.statecharts.Trigger;
import simphony.util.messages.MessageCenter;

public class Transition<T> {
    private DefaultStateChart<T> stateChart;
    private T agent;
    private Parameters params;
    private Queue<Object> queue;
    private Trigger trigger;
    private AbstractState<T> source;
    private AbstractState<T> target;
    private double priority;
    private TransitionAction<T> onTransition;
    private GuardCondition<T> guard;
    private String id;

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    protected T getAgent() {
        if (this.agent == null) {
            if (this.stateChart == null) {
                throw new IllegalStateException("The stateChart was not set in: " + this);
            }
            this.agent = this.stateChart.getAgent();
        }
        return this.agent;
    }

    protected Queue<Object> getQueue() {
        if (this.queue == null) {
            if (this.stateChart == null) {
                throw new IllegalStateException("The stateChart was not set in: " + this);
            }
            this.queue = this.stateChart.getQueue();
        }
        return this.queue;
    }

    protected void setStateChart(DefaultStateChart<T> stateChart) {
        this.stateChart = stateChart;
    }

    protected Transition(Trigger trigger, AbstractState<T> source, AbstractState<T> target) {
        this(trigger, source, target, 0.0);
    }

    protected Transition(Trigger trigger, AbstractState<T> source, AbstractState<T> target, double priority) {
        this("", trigger, source, target, priority);
    }

    protected Transition(String id, Trigger trigger, AbstractState<T> source, AbstractState<T> target, double priority) {
        this.id = id;
        this.trigger = trigger;
        this.source = source;
        this.target = target;
        this.priority = priority;
        if (trigger instanceof AbstractTrigger) {
            AbstractTrigger at = (AbstractTrigger)trigger;
            at.setTransition(this);
        }
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public AbstractState<T> getSource() {
        return this.source;
    }

    public AbstractState<T> getTarget() {
        return this.target;
    }

    protected boolean isTransitionConditionTrue() {
        return this.trigger.isTriggerConditionTrue() && this.checkGuard();
    }

    protected boolean isTransitionTriggered() {
        return this.trigger.isTriggered() && this.checkGuard();
    }

    protected boolean isResolveNow() {
        ISchedule schedule;
        RunEnvironment re = RunEnvironment.getInstance();
        if (re != null && (schedule = re.getCurrentSchedule()) != null) {
            double now = schedule.getTickCount();
            return Double.compare(now, this.trigger.getNextTime()) >= 0;
        }
        return false;
    }

    private boolean checkGuard() {
        try {
            return this.guard.condition(this.getAgent(), this, this.getParams());
        }
        catch (Exception e) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when checking guard: " + this.guard + " in " + this), (Throwable)e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    protected void registerGuard(GuardCondition<T> guard) {
        this.guard = guard;
    }

    protected boolean canTransitionZeroTime() {
        return this.trigger.canTransitionZeroTime();
    }

    protected boolean isTriggerQueueConsuming() {
        return this.trigger.isQueueConsuming();
    }

    public double getPriority() {
        return this.priority;
    }

    protected void initialize(DefaultStateChart<T> sc) {
        this.trigger.initialize();
        sc.scheduleResolveTime(this.trigger.getNextTime());
    }

    protected void registerOnTransition(TransitionAction<T> onTransition) {
        this.onTransition = onTransition;
    }

    protected void onTransition() {
        try {
            this.onTransition.action(this.getAgent(), this, this.getParams());
        }
        catch (Exception e) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when calling onTransition in transition: " + this), (Throwable)e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "Transition(\"" + this.id + "\", " + this.trigger + ", " + this.source + ", " + this.target + ", " + this.priority + ")";
    }

    public String getId() {
        return this.id;
    }

    protected void rescheduleRegularTransition(DefaultStateChart<T> stateChart, double currentTime) {
        if (this.trigger.isRecurring() && Double.compare(this.trigger.getNextTime(), currentTime) == 0) {
            this.initialize(stateChart);
        }
    }

    protected void rescheduleSelfTransition(DefaultStateChart<T> stateChart, double currentTime) {
        if (Double.compare(this.trigger.getNextTime(), currentTime) == 0) {
            this.initialize(stateChart);
        }
    }

    public void setNextPollingTime(double pollingTime) {
        this.trigger.setInterval(pollingTime);
    }

    public double getPollingTime() {
        return this.trigger.getInterval();
    }
}

