/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.parameter.Parameters;
import repast.simphony.statecharts.AbstractTrigger;
import repast.simphony.statecharts.Transition;
import repast.simphony.statecharts.TriggerDoubleFunction;
import simphony.util.messages.MessageCenter;

public class TimedTrigger<T>
extends AbstractTrigger<T> {
    private TriggerDoubleFunction<T> tdf;
    private double nextTime;
    private Parameters params;

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    public TimedTrigger(final double time) {
        this(new TriggerDoubleFunction<T>(){

            @Override
            public double value(T agent, Transition<T> transition, Parameters params) throws Exception {
                return time;
            }

            public String toString() {
                return Double.toString(time);
            }
        });
    }

    public TimedTrigger(TriggerDoubleFunction<T> tdf) {
        this.tdf = tdf;
    }

    @Override
    public boolean isRecurring() {
        return false;
    }

    @Override
    public double getInterval() {
        try {
            return this.tdf.value(this.getAgent(), this.transition, this.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public void initialize() {
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        try {
            double initializedTickCount = schedule.getTickCount();
            double time = this.tdf.value(this.getAgent(), this.transition, this.getParams());
            this.nextTime = initializedTickCount + time;
        }
        catch (Exception e) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when evaluating double function: " + this.tdf + " in " + this), (Throwable)e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getNextTime() {
        return this.nextTime;
    }

    @Override
    public boolean isTriggered() {
        return this.isTriggerConditionTrue();
    }

    @Override
    public boolean isTriggerConditionTrue() {
        return Double.compare(RunEnvironment.getInstance().getCurrentSchedule().getTickCount(), this.getNextTime()) == 0;
    }

    public String toString() {
        return "TimedTrigger with time: " + this.tdf;
    }

    @Override
    public boolean canTransitionZeroTime() {
        return false;
    }

    @Override
    public void setInterval(double interval) {
    }
}

