/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.PriorityType;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.statecharts.DefaultIntegrator;
import repast.simphony.statecharts.StateChart;
import repast.simphony.statecharts.StateChartBeginAction;
import repast.simphony.statecharts.StateChartResolveAction;

public enum StateChartScheduler {
    INSTANCE;

    private static final long MAX_BEFOFE_CLEAR = 100L;
    protected Map<Double, ResolveActionsMapValue> resolveActions = new HashMap<Double, ResolveActionsMapValue>();
    protected Map<Double, BeginActionsMapValue> beginActions = new HashMap<Double, BeginActionsMapValue>();
    protected DefaultIntegrator integrator = new DefaultIntegrator();
    long resolveClearCounter = 0L;
    long beginClearCounter = 0L;
    private boolean shouldInitialize = true;

    public void initialize() {
        this.integrator.reset();
        this.shouldInitialize = false;
        this.resolveClearCounter = 0L;
        this.beginClearCounter = 0L;
        for (ResolveActionsMapValue ramv : this.resolveActions.values()) {
            ramv.nullify();
        }
        this.resolveActions.clear();
        for (BeginActionsMapValue bamv : this.beginActions.values()) {
            bamv.nullify();
        }
        this.beginActions.clear();
        RunEnvironment.getInstance().getCurrentSchedule().schedule(ScheduleParameters.createAtEnd((double)0.0), new IAction(){

            public void execute() {
                StateChartScheduler.this.shouldInitialize = true;
            }
        });
    }

    protected void clearOldResolveActions() {
        ++this.resolveClearCounter;
        if (this.resolveClearCounter > 100L) {
            double time = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
            ArrayList<Double> keysToRemove = new ArrayList<Double>();
            for (Double rTime : this.resolveActions.keySet()) {
                if (rTime.compareTo(time) > 0) continue;
                keysToRemove.add(rTime);
            }
            for (Double key : keysToRemove) {
                this.resolveActions.remove(key);
            }
            this.resolveClearCounter = 0L;
        }
    }

    protected void clearOldBeginActions() {
        ++this.beginClearCounter;
        if (this.beginClearCounter > 100L) {
            double time = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
            ArrayList<Double> keysToRemove = new ArrayList<Double>();
            for (Double rTime : this.beginActions.keySet()) {
                if (rTime.compareTo(time) > 0) continue;
                keysToRemove.add(rTime);
            }
            for (Double key : keysToRemove) {
                this.beginActions.remove(key);
            }
            this.beginClearCounter = 0L;
        }
    }

    protected void scheduleResolveTime(double nextTime, StateChart<?> sc) {
        ResolveActionsMapValue ramv;
        if (this.shouldInitialize) {
            this.initialize();
        }
        if ((ramv = this.resolveActions.get(nextTime)) == null) {
            ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
            StateChartResolveAction scra = new StateChartResolveAction();
            ISchedulableAction ia = schedule.schedule(ScheduleParameters.createOneTime((double)nextTime, (PriorityType)PriorityType.FIRST_OF_LAST), (IAction)scra);
            ramv = new ResolveActionsMapValue(scra, ia);
            this.resolveActions.put(nextTime, ramv);
        }
        ramv.registerListener(sc);
    }

    public static void beginNow(StateChart<?> sc) {
        INSTANCE.scheduleBeginTime(0.0, sc);
    }

    public static void beginLater(double later, StateChart<?> sc) {
        INSTANCE.scheduleBeginTime(later, sc);
    }

    public void beginNowWithoutScheduling(StateChart<?> sc) {
        if (this.shouldInitialize) {
            this.initialize();
        }
        if (sc != null) {
            sc.begin(this.integrator);
        }
    }

    public void scheduleBeginTime(double nextTime, final StateChart<?> sc) {
        double currentTickCount;
        if (this.shouldInitialize) {
            this.initialize();
        }
        if (nextTime < 0.0) {
            nextTime = 0.0;
        }
        if (Double.compare(currentTickCount = RunEnvironment.getInstance().getCurrentSchedule().getTickCount(), nextTime) > 0) {
            nextTime = currentTickCount + nextTime;
        }
        if (Double.compare(currentTickCount, nextTime) == 0) {
            ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
            ISchedulableAction iSchedulableAction = schedule.schedule(ScheduleParameters.createOneTime((double)currentTickCount, (PriorityType)PriorityType.FIRST), new IAction(){

                public void execute() {
                    if (sc != null) {
                        sc.begin(StateChartScheduler.this.integrator);
                    }
                }
            });
        } else {
            BeginActionsMapValue bamv = this.beginActions.get(nextTime);
            if (bamv == null) {
                ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
                StateChartBeginAction scba = new StateChartBeginAction(this.integrator);
                ISchedulableAction ia = schedule.schedule(ScheduleParameters.createOneTime((double)nextTime, (PriorityType)PriorityType.FIRST), (IAction)scba);
                bamv = new BeginActionsMapValue(scba, ia);
                this.beginActions.put(nextTime, bamv);
            }
            bamv.registerListener(sc);
        }
    }

    protected void removeResolveTime(double nextTime, StateChart<?> sc) {
        if (this.resolveActions.containsKey(nextTime)) {
            ResolveActionsMapValue ramv = this.resolveActions.get(nextTime);
            ramv.removeListener(sc);
            if (ramv.toRemove()) {
                this.resolveActions.remove(nextTime);
            }
        } else {
            throw new IllegalStateException("Excess removeResolveTime call detected for StateChart: " + sc);
        }
    }

    static class BeginActionsMapValue {
        private StateChartBeginAction scba;
        private ISchedulableAction isa;

        protected BeginActionsMapValue(StateChartBeginAction scba, ISchedulableAction isa) {
            this.scba = scba;
            this.isa = isa;
        }

        protected void registerListener(StateChart<?> sc) {
            this.scba.registerListener(sc);
        }

        protected void nullify() {
            this.scba.removeAllListeners();
            RunEnvironment.getInstance().getCurrentSchedule().removeAction(this.isa);
            this.isa = null;
            this.scba = null;
        }
    }

    static class ResolveActionsMapValue {
        private StateChartResolveAction scra;
        private ISchedulableAction isa;
        private boolean remove = false;

        protected ResolveActionsMapValue(StateChartResolveAction scra, ISchedulableAction isa) {
            this.scra = scra;
            this.isa = isa;
        }

        protected void registerListener(StateChart<?> sc) {
            this.scra.registerListener(sc);
        }

        protected void removeListener(StateChart<?> sc) {
            this.scra.removeListener(sc);
            if (!this.scra.hasListeners()) {
                RunEnvironment.getInstance().getCurrentSchedule().removeAction(this.isa);
                this.isa = null;
                this.scra = null;
                this.remove = true;
            }
        }

        protected void nullify() {
            this.scra.removeAllListeners();
            RunEnvironment.getInstance().getCurrentSchedule().removeAction(this.isa);
            this.isa = null;
            this.scra = null;
            this.remove = true;
        }

        protected boolean toRemove() {
            return this.remove;
        }
    }
}

