/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import cern.jet.random.Uniform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.random.RandomHelper;
import repast.simphony.statecharts.StateChart;
import repast.simphony.statecharts.StateChartScheduler;
import repast.simphony.util.SimUtilities;

public class StateChartResolveAction
implements IAction {
    Map<StateChart<?>, Long> scCountsMap = new LinkedHashMap();
    private Comparator<StateChart<?>> pComp = new PriorityComparator();

    public void registerListener(StateChart<?> sc) {
        if (!this.scCountsMap.containsKey(sc)) {
            this.scCountsMap.put(sc, 0L);
        }
        long l = this.scCountsMap.get(sc);
        this.scCountsMap.put(sc, l + 1L);
    }

    public void removeListener(StateChart<?> sc) {
        if (this.scCountsMap.containsKey(sc)) {
            long l = this.scCountsMap.get(sc);
            if (l <= 1L) {
                this.scCountsMap.remove(sc);
            } else {
                this.scCountsMap.put(sc, l - 1L);
            }
        }
    }

    public void removeAllListeners() {
        this.scCountsMap.clear();
    }

    protected void notifyListeners() {
        ArrayList temp = new ArrayList(this.scCountsMap.keySet());
        SimUtilities.shuffle(temp, (Uniform)RandomHelper.getUniform());
        Collections.sort(temp, this.pComp);
        for (StateChart stateChart : temp) {
            stateChart.resolve();
        }
        this.scCountsMap.clear();
    }

    public boolean hasListeners() {
        return !this.scCountsMap.isEmpty();
    }

    public void execute() {
        this.notifyListeners();
        StateChartScheduler.INSTANCE.clearOldResolveActions();
    }

    static class PriorityComparator
    implements Comparator<StateChart<?>> {
        PriorityComparator() {
        }

        @Override
        public int compare(StateChart<?> s1, StateChart<?> s2) {
            double index2;
            double index1 = s1.getPriority();
            return index1 < (index2 = s2.getPriority()) ? 1 : (index1 == index2 ? 0 : -1);
        }
    }
}

