/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import repast.simphony.statecharts.AbstractState;
import repast.simphony.statecharts.BranchState;
import repast.simphony.statecharts.CompositeState;
import repast.simphony.statecharts.DefaultStateChart;
import repast.simphony.statecharts.SelfTransition;
import repast.simphony.statecharts.StateChart;
import repast.simphony.statecharts.Transition;
import repast.simphony.statecharts.TransitionResolutionStrategy;

public class StateChartBuilder<T> {
    private double priority = 0.0;
    private TransitionResolutionStrategy trs = TransitionResolutionStrategy.PRIORITY;
    private List<BranchState<T>> branches = new ArrayList<BranchState<T>>();
    private AbstractState<T> entryState;
    private Set<AbstractState<T>> states = new LinkedHashSet<AbstractState<T>>();
    private Set<SelfTransition<T>> selfTransitions = new LinkedHashSet<SelfTransition<T>>();
    private Set<Transition<T>> regularTransitions = new LinkedHashSet<Transition<T>>();
    private T agent;
    private Map<AbstractState<T>, String> stateUuidMap = new HashMap<AbstractState<T>, String>();
    private Map<Transition<T>, String> transitionUuidMap = new HashMap<Transition<T>, String>();

    protected T getAgent() {
        return this.agent;
    }

    public StateChartBuilder(T agent, AbstractState<T> entryState, String entryStateUuid) {
        this.agent = agent;
        this.registerEntryState(entryState, entryStateUuid);
    }

    public StateChartBuilder(T agent, AbstractState<T> entryState) {
        this(agent, entryState, null);
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    protected void registerEntryState(AbstractState<T> entryState, String uuid) {
        this.entryState = entryState;
        this.addStateToStates(entryState, uuid);
    }

    protected void addStateToStates(AbstractState<T> state, String uuid) {
        if (this.states.add(state)) {
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
            }
            this.stateUuidMap.put(state, uuid);
        }
    }

    protected void registerEntryState(AbstractState<T> entryState) {
        this.registerEntryState(entryState, null);
    }

    public void addRootState(AbstractState<T> state, String uuid) {
        this.addStateToStates(state, uuid);
    }

    public void addRootState(AbstractState<T> state) {
        this.addRootState(state, null);
    }

    public void addSelfTransition(SelfTransition<T> transition) {
        this.addSelfTransition(transition, null);
    }

    public void addSelfTransition(SelfTransition<T> transition, String uuid) {
        if (this.selfTransitions.add(transition)) {
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
            }
            this.transitionUuidMap.put(transition, uuid);
        }
    }

    public void addRegularTransition(Transition<T> transition) {
        this.addRegularTransition(transition, null);
    }

    public void addRegularTransition(Transition<T> transition, String uuid) {
        if (this.regularTransitions.add(transition)) {
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
            }
            this.transitionUuidMap.put(transition, uuid);
        }
    }

    protected void setStateChartProperties(DefaultStateChart<T> stateChart) {
        if (this.entryState == null) {
            throw new IllegalStateException("An entry state was not added to the StateChart.");
        }
        stateChart.setPriority(this.priority);
        stateChart.setTransitionResolutionStrategy(this.trs);
        stateChart.registerEntryState(this.entryState);
        for (AbstractState<T> abstractState : this.states) {
            stateChart.addState(abstractState);
        }
        for (SelfTransition selfTransition : this.selfTransitions) {
            stateChart.addSelfTransition(selfTransition);
        }
        for (Transition transition : this.regularTransitions) {
            stateChart.addRegularTransition(transition);
        }
        this.findBranches(this.states);
        for (BranchState branchState : this.branches) {
            branchState.initializeBranch(stateChart);
        }
        stateChart.setStateUuidMap(this.stateUuidMap);
        for (AbstractState abstractState : this.states) {
            if (!(abstractState instanceof CompositeState)) continue;
            CompositeState compositeState = (CompositeState)abstractState;
            Map map = compositeState.getStateUuidMap();
            for (Map.Entry entry : map.entrySet()) {
                stateChart.putStateUuid(entry.getKey(), entry.getValue());
            }
            compositeState.clearStateUuidMap();
        }
        stateChart.setTransitionUuidMap(this.transitionUuidMap);
    }

    private void findBranches(Collection<AbstractState<T>> states2) {
        for (AbstractState<T> state : states2) {
            if (state instanceof BranchState) {
                BranchState branch = (BranchState)state;
                this.branches.add(branch);
                continue;
            }
            if (!(state instanceof CompositeState)) continue;
            CompositeState compositeState = (CompositeState)state;
            this.findBranches(compositeState.children);
        }
    }

    public StateChart<T> build() {
        DefaultStateChart<T> result = new DefaultStateChart<T>(this.getAgent());
        this.setStateChartProperties(result);
        return result;
    }
}

