/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import cern.jet.random.Uniform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.random.RandomHelper;
import repast.simphony.statecharts.StateChart;
import repast.simphony.statecharts.StateChartScheduler;
import repast.simphony.statecharts.StateChartSimIntegrator;
import repast.simphony.util.SimUtilities;

public class StateChartBeginAction
implements IAction {
    Set<StateChart<?>> scSet = new LinkedHashSet();
    private StateChartSimIntegrator integrator;
    private Comparator<StateChart<?>> pComp = new PriorityComparator();

    public StateChartBeginAction(StateChartSimIntegrator integrator) {
        this.integrator = integrator;
    }

    public void registerListener(StateChart<?> sc) {
        if (sc != null) {
            this.scSet.add(sc);
        }
    }

    public void removeListener(StateChart<?> sc) {
        if (sc != null) {
            this.scSet.remove(sc);
        }
    }

    public void removeAllListeners() {
        this.scSet.clear();
    }

    protected void notifyListeners() {
        ArrayList temp = new ArrayList(this.scSet);
        SimUtilities.shuffle(temp, (Uniform)RandomHelper.getUniform());
        Collections.sort(temp, this.pComp);
        for (StateChart stateChart : temp) {
            stateChart.begin(this.integrator);
        }
    }

    public boolean hasListeners() {
        return !this.scSet.isEmpty();
    }

    public void execute() {
        this.notifyListeners();
        StateChartScheduler.INSTANCE.clearOldBeginActions();
    }

    static class PriorityComparator
    implements Comparator<StateChart<?>> {
        PriorityComparator() {
        }

        @Override
        public int compare(StateChart<?> s1, StateChart<?> s2) {
            double index2;
            double index1 = s1.getPriority();
            return index1 < (index2 = s2.getPriority()) ? 1 : (index1 == index2 ? 0 : -1);
        }
    }
}

