/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import repast.simphony.statecharts.AbstractState;
import repast.simphony.statecharts.AlwaysTrigger;
import repast.simphony.statecharts.GuardCondition;
import repast.simphony.statecharts.SelfTransition;
import repast.simphony.statecharts.TransitionAction;
import repast.simphony.statecharts.TransitionBuilder;
import repast.simphony.statecharts.Trigger;

public class SelfTransitionBuilder<T> {
    private Trigger trigger;
    private AbstractState<T> state;
    private double priority = 0.0;
    private TransitionAction<T> onTransition = TransitionBuilder.createEmptyOnTransition();
    private GuardCondition<T> guard = TransitionBuilder.createEmptyGuard();
    private String id;

    public SelfTransitionBuilder(AbstractState<T> state) {
        this("NULL", state);
    }

    public SelfTransitionBuilder(String id, AbstractState<T> state) {
        this.id = id;
        this.state = state;
    }

    public SelfTransitionBuilder<T> setPriority(double priority) {
        this.priority = priority;
        return this;
    }

    public SelfTransitionBuilder<T> addTrigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public SelfTransitionBuilder<T> registerOnTransition(TransitionAction<T> onTransition) {
        this.onTransition = onTransition;
        return this;
    }

    public SelfTransitionBuilder<T> registerGuard(GuardCondition<T> guard) {
        this.guard = guard;
        return this;
    }

    public SelfTransition<T> build() {
        if (this.trigger == null) {
            this.trigger = new AlwaysTrigger();
        }
        SelfTransition<T> result = new SelfTransition<T>(this.id, this.trigger, this.state, this.priority);
        result.registerGuard(this.guard);
        result.registerOnTransition(this.onTransition);
        return result;
    }
}

