/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.parameter.Parameters;
import repast.simphony.random.RandomHelper;
import repast.simphony.statecharts.AbstractTrigger;
import repast.simphony.statecharts.Transition;
import repast.simphony.statecharts.TriggerDoubleFunction;
import simphony.util.messages.MessageCenter;

public class ProbabilityTrigger<T>
extends AbstractTrigger<T> {
    private TriggerDoubleFunction<T> tdf;
    private double pollingTime;
    private double nextPollingTime;
    private double initializedTickCount;
    private double probability;
    private Parameters params;

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    public ProbabilityTrigger(final double probability, double pollingTime) {
        this(new TriggerDoubleFunction<T>(){

            @Override
            public double value(T agent, Transition<T> transition, Parameters params) throws Exception {
                return probability;
            }

            public String toString() {
                return Double.toString(probability);
            }
        }, pollingTime);
    }

    public ProbabilityTrigger(double probability) {
        this(probability, 1.0);
    }

    public ProbabilityTrigger(TriggerDoubleFunction<T> tdf) {
        this(tdf, 1.0);
    }

    public ProbabilityTrigger(TriggerDoubleFunction<T> tdf, double pollingTime) {
        this.tdf = tdf;
        this.pollingTime = pollingTime;
        this.nextPollingTime = pollingTime;
    }

    @Override
    public boolean isRecurring() {
        return true;
    }

    @Override
    public double getInterval() {
        return this.pollingTime;
    }

    @Override
    public void setInterval(double interval) {
        this.nextPollingTime = interval;
    }

    @Override
    public void initialize() {
        this.pollingTime = this.nextPollingTime;
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        this.initializedTickCount = schedule.getTickCount();
    }

    @Override
    public double getNextTime() {
        return this.initializedTickCount + this.pollingTime;
    }

    @Override
    public boolean isTriggered() {
        double now = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
        return Double.compare(now, this.getNextTime()) >= 0 && this.isTriggerConditionTrue();
    }

    @Override
    public boolean isTriggerConditionTrue() {
        double rand = RandomHelper.nextDouble();
        try {
            return this.tdf.value(this.getAgent(), this.transition, this.getParams()) > rand;
        }
        catch (Exception e) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when evaluating double function: " + this.tdf + " in " + this), (Throwable)e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "ProbabilityTrigger with probability: " + this.probability + " and pollingTime: " + this.pollingTime;
    }

    @Override
    public boolean canTransitionZeroTime() {
        return false;
    }
}

