/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import java.util.Queue;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.statecharts.AbstractTrigger;
import repast.simphony.statecharts.AgentTransitionMessageChecker;
import repast.simphony.statecharts.MessageChecker;
import repast.simphony.statecharts.Transition;

public class MessageTrigger<T>
extends AbstractTrigger<T> {
    private Queue<Object> queue;
    private double pollingTime;
    private double nextPollingTime;
    private double initializedTickCount;
    private MessageChecker messageChecker;

    protected Queue<Object> getQueue() {
        if (this.queue == null) {
            if (this.transition == null) {
                throw new IllegalStateException("The transition was not set in a MessageTrigger.");
            }
            this.queue = this.transition.getQueue();
        }
        return this.queue;
    }

    @Override
    protected void setTransition(Transition<T> transition) {
        super.setTransition(transition);
        if (this.messageChecker instanceof AgentTransitionMessageChecker) {
            AgentTransitionMessageChecker atmc = (AgentTransitionMessageChecker)this.messageChecker;
            atmc.setTransition(transition);
        }
    }

    protected MessageTrigger(Queue<Object> queue, MessageChecker messageChecker, double pollingTime) {
        this.queue = queue;
        this.messageChecker = messageChecker;
        this.pollingTime = pollingTime;
        this.nextPollingTime = pollingTime;
    }

    protected MessageTrigger(Queue<Object> queue, MessageChecker messageChecker) {
        this(queue, messageChecker, 1.0);
    }

    public MessageTrigger(MessageChecker messageChecker, double pollingTime) {
        this(null, messageChecker, pollingTime);
    }

    public MessageTrigger(MessageChecker messageChecker) {
        this(null, messageChecker, 1.0);
    }

    @Override
    public boolean isRecurring() {
        return true;
    }

    @Override
    public double getInterval() {
        return this.pollingTime;
    }

    @Override
    public void setInterval(double interval) {
        this.nextPollingTime = interval;
    }

    @Override
    public void initialize() {
        this.pollingTime = this.nextPollingTime;
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        this.initializedTickCount = schedule.getTickCount();
    }

    @Override
    public double getNextTime() {
        return this.initializedTickCount + this.pollingTime;
    }

    @Override
    public boolean isTriggered() {
        double now = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
        return Double.compare(now, this.getNextTime()) >= 0 && this.isTriggerConditionTrue();
    }

    @Override
    public boolean isTriggerConditionTrue() {
        if (this.getQueue().isEmpty()) {
            return false;
        }
        return this.messageChecker.checkMessage(this.queue.peek());
    }

    public String toString() {
        return "MessageTrigger with pollingTime: " + this.pollingTime;
    }

    @Override
    public boolean canTransitionZeroTime() {
        return true;
    }

    @Override
    public boolean isQueueConsuming() {
        return true;
    }
}

