/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.parameter.Parameters;
import repast.simphony.statecharts.AgentTransitionMessageChecker;
import repast.simphony.statecharts.MessageEquals;
import repast.simphony.statecharts.Transition;
import simphony.util.messages.MessageCenter;

public class MessageEqualsMessageChecker<T, U>
extends AgentTransitionMessageChecker<T> {
    private MessageEquals<T> messageEquals;
    private Class<? extends U> messageClass;
    private Parameters params;

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    public MessageEqualsMessageChecker(MessageEquals<T> messageEquals, Class<? extends U> messageClass) {
        this.messageEquals = messageEquals;
        this.messageClass = messageClass;
    }

    public MessageEqualsMessageChecker(final U messageEquals, Class<? extends U> messageClass) {
        this((U)new MessageEquals<T>(){

            @Override
            public Object messageValue(T agent, Transition<T> transition, Parameters params) throws Exception {
                return messageEquals;
            }

            public String toString() {
                return messageEquals.toString();
            }
        }, messageClass);
    }

    @Override
    public boolean checkMessage(Object message) {
        boolean result = false;
        if (this.messageClass.isInstance(message)) {
            try {
                result = message.equals(this.messageEquals.messageValue(this.getAgent(), this.transition, this.getParams()));
            }
            catch (Exception e) {
                MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when calling message equals in: " + this), (Throwable)e, new Object[0]);
            }
        }
        return result;
    }

    public String toString() {
        return "MessageEqualsMessageChecker with " + this.messageEquals;
    }
}

