/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.parameter.Parameters;
import repast.simphony.statecharts.AgentTransitionMessageChecker;
import repast.simphony.statecharts.MessageCondition;
import simphony.util.messages.MessageCenter;

public class MessageConditionMessageChecker<T, U>
extends AgentTransitionMessageChecker<T> {
    private MessageCondition<T, U> messageCondition;
    private Class<? extends U> messageClass;
    private Parameters params;

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    public MessageConditionMessageChecker(MessageCondition<T, U> messageCondition, Class<? extends U> messageClass) {
        this.messageCondition = messageCondition;
        this.messageClass = messageClass;
    }

    @Override
    public boolean checkMessage(Object message) {
        boolean result = false;
        if (this.messageClass.isInstance(message)) {
            try {
                result = this.messageCondition.isTrue(this.getAgent(), this.transition, this.messageClass.cast(message), this.getParams());
            }
            catch (Exception e) {
                MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when calling message condition in: " + this), (Throwable)e, new Object[0]);
            }
        }
        return result;
    }

    public String toString() {
        return "MessageConditionMessageChecker with " + this.messageCondition;
    }
}

