/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import cern.jet.random.Exponential;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.parameter.Parameters;
import repast.simphony.random.RandomHelper;
import repast.simphony.statecharts.AbstractTrigger;
import repast.simphony.statecharts.Transition;
import repast.simphony.statecharts.TriggerDoubleFunction;
import simphony.util.messages.MessageCenter;

public class ExponentialDecayRateTrigger<T>
extends AbstractTrigger<T> {
    private TriggerDoubleFunction<T> tdf;
    private double currentInterval;
    private double initializedTickCount;
    private Parameters params;

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    public ExponentialDecayRateTrigger(final double decayRate) {
        this(new TriggerDoubleFunction<T>(){

            @Override
            public double value(T agent, Transition<T> transition, Parameters params) throws Exception {
                return decayRate;
            }

            public String toString() {
                return Double.toString(decayRate);
            }
        });
    }

    public ExponentialDecayRateTrigger(TriggerDoubleFunction<T> tdf) {
        this.tdf = tdf;
    }

    @Override
    public boolean isRecurring() {
        return false;
    }

    @Override
    public double getInterval() {
        return this.currentInterval;
    }

    @Override
    public void initialize() {
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        this.initializedTickCount = schedule.getTickCount();
        Exponential exp = RandomHelper.getExponential();
        if (exp == null) {
            exp = RandomHelper.createExponential((double)1.0);
        }
        try {
            double lambda = this.tdf.value(this.getAgent(), this.transition, this.getParams());
            this.currentInterval = exp.nextDouble(lambda);
        }
        catch (Exception e) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when evaluating double function: " + this.tdf + " in " + this), (Throwable)e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getNextTime() {
        return this.initializedTickCount + this.currentInterval;
    }

    @Override
    public boolean isTriggered() {
        return this.isTriggerConditionTrue();
    }

    @Override
    public boolean isTriggerConditionTrue() {
        return Double.compare(RunEnvironment.getInstance().getCurrentSchedule().getTickCount(), this.getNextTime()) >= 0;
    }

    public String toString() {
        return "ExponentialDecayRateTrigger with decayRate: " + this.tdf + " and currentInterval: " + this.currentInterval;
    }

    @Override
    public boolean canTransitionZeroTime() {
        return false;
    }

    @Override
    public void setInterval(double interval) {
    }
}

