/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import cern.jet.random.Uniform;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.collections15.ListUtils;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.parameter.Parameters;
import repast.simphony.random.RandomHelper;
import repast.simphony.statecharts.AbstractState;
import repast.simphony.statecharts.AlwaysTrigger;
import repast.simphony.statecharts.BranchState;
import repast.simphony.statecharts.CompositeState;
import repast.simphony.statecharts.FinalState;
import repast.simphony.statecharts.HistoryState;
import repast.simphony.statecharts.SelfTransition;
import repast.simphony.statecharts.SimpleState;
import repast.simphony.statecharts.StateChart;
import repast.simphony.statecharts.StateChartListener;
import repast.simphony.statecharts.StateChartScheduler;
import repast.simphony.statecharts.StateChartSimIntegrator;
import repast.simphony.statecharts.Transition;
import repast.simphony.statecharts.TransitionResolutionStrategy;
import repast.simphony.statecharts.Trigger;
import repast.simphony.util.SimUtilities;

public class DefaultStateChart<T>
implements StateChart<T> {
    private TransitionResolutionStrategy transitionResolutionStrategy = TransitionResolutionStrategy.PRIORITY;
    private AbstractState<T> entryState;
    private Set<AbstractState<T>> states = new HashSet<AbstractState<T>>();
    protected List<Transition<T>> regularTransitions = new ArrayList<Transition<T>>();
    protected List<Transition<T>> activeRegularTransitions = new ArrayList<Transition<T>>();
    protected List<Transition<T>> selfTransitions = new ArrayList<Transition<T>>();
    protected List<Transition<T>> activeSelfTransitions = new ArrayList<Transition<T>>();
    protected SimpleState<T> currentSimpleState;
    private Map<AbstractState<T>, String> stateUuidMap;
    private Map<Transition<T>, String> transitionUuidMap;
    private Comparator<Transition<T>> pComp = new PriorityComparator<T>();
    private Queue<Object> queue = new ArrayDeque<Object>();
    private double priority = 0.0;
    private T agent;
    Parameters params;
    private Set<StateChartListener> stateChartListeners = new LinkedHashSet<StateChartListener>();

    protected DefaultStateChart(T agent) {
        this.agent = agent;
    }

    protected TransitionResolutionStrategy getTransitionResolutionStrategy() {
        return this.transitionResolutionStrategy;
    }

    protected void setTransitionResolutionStrategy(TransitionResolutionStrategy transitionResolutionStrategy) {
        this.transitionResolutionStrategy = transitionResolutionStrategy;
    }

    protected void setStateUuidMap(Map<AbstractState<T>, String> stateUuidMap) {
        this.stateUuidMap = stateUuidMap;
    }

    protected void putStateUuid(AbstractState<T> state, String uuid) {
        this.stateUuidMap.put(state, uuid);
    }

    protected void setTransitionUuidMap(Map<Transition<T>, String> transitionUuidMap) {
        this.transitionUuidMap = transitionUuidMap;
    }

    protected void putTransitionUuid(Transition<T> transition, String uuid) {
        this.transitionUuidMap.put(transition, uuid);
    }

    protected void registerEntryState(AbstractState<T> state) {
        this.entryState = state;
        this.addState(state);
    }

    @Override
    public void begin(StateChartSimIntegrator integrator) {
        if (this.entryState == null) {
            throw new IllegalStateException("An entry state was not registered in the StateChart.");
        }
        if (integrator.integrate(this)) {
            this.clearTransitions(null);
            List<AbstractState<T>> statesToEnter = this.getStatesToEnter(null, this.entryState);
            this.stateInit(statesToEnter);
        }
    }

    @Override
    public void stop() {
        this.clearTransitions(null);
    }

    private void partitionQueueConsuming(List<Transition<T>> transitions, List<Transition<T>> queueConsuming, List<Transition<T>> nonQueueConsuming) {
        for (Transition<T> t : transitions) {
            if (t.isTriggerQueueConsuming()) {
                queueConsuming.add(t);
                continue;
            }
            nonQueueConsuming.add(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void stateInit(List<AbstractState<T>> statesToEnter) {
        this.currentSimpleState = (SimpleState)statesToEnter.get(statesToEnter.size() - 1);
        this.notifyChangeListeners();
        for (AbstractState<T> abstractState : statesToEnter) {
            abstractState.onEnter();
        }
        for (Transition transition : this.selfTransitions) {
            if (!statesToEnter.contains(transition.getSource())) continue;
            this.activeSelfTransitions.add(transition);
            transition.initialize(this);
        }
        if (this.currentSimpleState instanceof FinalState) {
            this.clearTransitions(null);
        } else {
            void var2_9;
            Object var2_6 = null;
            ArrayList transitionsToIgnore = new ArrayList();
            if (this.currentSimpleState instanceof BranchState) {
                ArrayList<Transition<T>> branchCandidateTransitions = new ArrayList<Transition<T>>();
                for (Transition<T> t2 : this.regularTransitions) {
                    if (this.currentSimpleState != t2.getSource()) continue;
                    branchCandidateTransitions.add(t2);
                }
                transitionsToIgnore.addAll(branchCandidateTransitions);
                Transition defaultTransition = null;
                ArrayList<Transition<T>> arrayList = new ArrayList<Transition<T>>();
                for (Transition transition : branchCandidateTransitions) {
                    if (transition.getTrigger() instanceof AlwaysTrigger) {
                        defaultTransition = transition;
                        continue;
                    }
                    if (!transition.isTransitionConditionTrue()) continue;
                    arrayList.add(transition);
                }
                if (defaultTransition == null) {
                    throw new IllegalStateException("All branch states must define at least one default transition");
                }
                Transition<T> transition = this.chooseOneTransition(arrayList);
                if (transition == null) {
                    Transition transition2 = defaultTransition;
                } else {
                    Transition<T> transition3 = transition;
                }
            }
            ArrayList<Transition<T>> newTransitionsToActivate = new ArrayList<Transition<T>>();
            for (Transition<T> t : this.regularTransitions) {
                if (transitionsToIgnore.contains(t) || !statesToEnter.contains(t.getSource())) continue;
                newTransitionsToActivate.add(t);
            }
            ArrayList<Transition<T>> newTransitionsToActivateZeroTime = new ArrayList<Transition<T>>();
            for (Transition transition : newTransitionsToActivate) {
                if (!transition.canTransitionZeroTime()) continue;
                newTransitionsToActivateZeroTime.add(transition);
            }
            ArrayList<Transition<T>> arrayList = new ArrayList<Transition<T>>();
            ArrayList<Transition<T>> arrayList2 = new ArrayList<Transition<T>>();
            this.partitionQueueConsuming(newTransitionsToActivateZeroTime, arrayList, arrayList2);
            ArrayList<Transition<T>> activeRegularQueueConsuming = new ArrayList<Transition<T>>();
            ArrayList<Transition<T>> activeRegularNonQueueConsuming = new ArrayList<Transition<T>>();
            this.partitionQueueConsuming(this.activeRegularTransitions, activeRegularQueueConsuming, activeRegularNonQueueConsuming);
            ArrayList<Object> nonQueueConsumingValid = new ArrayList<Object>();
            if (var2_9 != null) {
                nonQueueConsumingValid.add(var2_9);
            }
            for (Transition transition : activeRegularNonQueueConsuming) {
                if (!transition.isTransitionTriggered()) continue;
                nonQueueConsumingValid.add(transition);
            }
            for (Transition transition : arrayList2) {
                if (!transition.isTransitionConditionTrue()) continue;
                nonQueueConsumingValid.add(transition);
            }
            this.activeRegularTransitions.addAll(newTransitionsToActivate);
            for (Transition transition : newTransitionsToActivate) {
                transition.initialize(this);
            }
            List list = ListUtils.union(arrayList, activeRegularQueueConsuming);
            ArrayList<Transition> queueConsumingValid = new ArrayList<Transition>();
            if (list.isEmpty()) {
                this.queue.clear();
            } else {
                boolean foundIsResolveNow = false;
                for (Transition transition : activeRegularQueueConsuming) {
                    if (!transition.isResolveNow()) continue;
                    foundIsResolveNow = true;
                    break;
                }
                if (foundIsResolveNow || !arrayList.isEmpty()) {
                    do {
                        for (Transition transition : arrayList) {
                            if (!transition.isTransitionConditionTrue()) continue;
                            queueConsumingValid.add(transition);
                        }
                        for (Transition transition : activeRegularQueueConsuming) {
                            if (!transition.isTransitionTriggered()) continue;
                            queueConsumingValid.add(transition);
                        }
                        if (!queueConsumingValid.isEmpty()) break;
                        this.queue.poll();
                    } while (!this.queue.isEmpty());
                }
            }
            Transition<T> t = this.chooseOneTransition(ListUtils.union(nonQueueConsumingValid, queueConsumingValid));
            if (t != null) {
                if (t.isTriggerQueueConsuming()) {
                    this.queue.poll();
                }
                this.makeRegularTransition(t);
            }
        }
    }

    private void clearTransitions(AbstractState<T> as) {
        this.deactivateTransitions(as, this.activeSelfTransitions);
        this.deactivateTransitions(as, this.activeRegularTransitions);
    }

    private void deactivateTransitions(AbstractState<T> as, List<Transition<T>> transitions) {
        List<Object> candidateTransitions = new ArrayList();
        if (as == null) {
            candidateTransitions = transitions;
        } else {
            for (Transition<T> t : transitions) {
                if (!t.getSource().getId().equals(as.getId())) continue;
                candidateTransitions.add(t);
            }
        }
        double now = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
        for (Transition transition : candidateTransitions) {
            Trigger tr = transition.getTrigger();
            double nextTime = tr.getNextTime();
            if (Double.compare(nextTime, now) <= 0) continue;
            this.removeResolveTime(nextTime);
        }
        transitions.removeAll(candidateTransitions);
    }

    protected void addState(AbstractState<T> state) {
        if (!this.states.contains(state)) {
            state.setStateChart(this);
            this.states.add(state);
        }
    }

    protected void addRegularTransition(Transition<T> transition) {
        transition.setStateChart(this);
        this.addState(transition.getSource());
        this.addState(transition.getTarget());
        this.regularTransitions.add(transition);
    }

    protected void addSelfTransition(SelfTransition<T> transition) {
        transition.setStateChart(this);
        this.selfTransitions.add(transition);
    }

    @Override
    public SimpleState<T> getCurrentSimpleState() {
        return this.currentSimpleState;
    }

    private List<AbstractState<T>> getStatesToExit(AbstractState<T> lca) {
        ArrayList<AbstractState<T>> statesToExit = new ArrayList<AbstractState<T>>();
        CompositeState s = this.getCurrentSimpleState();
        while (s != lca && s != null) {
            if (s instanceof CompositeState) {
                CompositeState cs = s;
                for (HistoryState hs : cs.getHistoryStates()) {
                    if (hs.isShallow()) {
                        hs.setDestination((AbstractState)statesToExit.get(statesToExit.size() - 1));
                        continue;
                    }
                    hs.setDestination(this.getCurrentSimpleState());
                }
            }
            statesToExit.add(s);
            s = s.getParent();
        }
        return statesToExit;
    }

    private List<AbstractState<T>> getStatesToEnter(AbstractState<T> lca, AbstractState<T> target) {
        LinkedList<AbstractState<T>> statesToEnter = new LinkedList<AbstractState<T>>();
        HashMap compositeHistoryMap = new HashMap();
        AbstractState<T> t = target;
        while (!(t instanceof SimpleState)) {
            if (t instanceof CompositeState) {
                CompositeState cs = (CompositeState)t;
                t = cs.getEntryState();
                continue;
            }
            if (!(t instanceof HistoryState)) continue;
            HistoryState hs = (HistoryState)t;
            compositeHistoryMap.put(hs.getParent(), hs);
            t = hs.getDestination();
        }
        while (t != lca && t != null) {
            if (compositeHistoryMap.containsKey(t)) {
                statesToEnter.addFirst((AbstractState)compositeHistoryMap.get(t));
            }
            statesToEnter.addFirst(t);
            t = t.getParent();
        }
        return statesToEnter;
    }

    private void makeRegularTransition(Transition<T> transition) {
        AbstractState<T> source = transition.getSource();
        AbstractState<T> target = transition.getTarget();
        AbstractState<T> lca = source.calculateLowestCommonAncestor(target);
        List<AbstractState<T>> statesToExit = this.getStatesToExit(lca);
        this.currentSimpleState = null;
        for (AbstractState<T> as : statesToExit) {
            this.clearTransitions(as);
            as.onExit();
        }
        transition.onTransition();
        List<AbstractState<T>> statesToEnter = this.getStatesToEnter(lca, target);
        this.stateInit(statesToEnter);
    }

    private List<Transition<T>> getTriggeredTransitions(List<Transition<T>> transitions) {
        ArrayList<Transition<T>> triggeredTransitions = new ArrayList<Transition<T>>();
        for (Transition<T> t : transitions) {
            if (!t.isTransitionTriggered()) continue;
            triggeredTransitions.add(t);
        }
        return triggeredTransitions;
    }

    @Override
    public void resolve() {
        ArrayList<Transition<T>> queueConsumingActiveSelfTransitions = new ArrayList<Transition<T>>();
        ArrayList<Transition<T>> nonQueueConsumingActiveSelfTransitions = new ArrayList<Transition<T>>();
        this.partitionQueueConsuming(this.activeSelfTransitions, queueConsumingActiveSelfTransitions, nonQueueConsumingActiveSelfTransitions);
        for (Transition<T> t : this.getTriggeredTransitions(nonQueueConsumingActiveSelfTransitions)) {
            t.onTransition();
        }
        ArrayList<Transition<T>> queueConsumingActiveRegularTransitions = new ArrayList<Transition<T>>();
        ArrayList<Transition<T>> nonQueueConsumingActiveRegularTransitions = new ArrayList<Transition<T>>();
        this.partitionQueueConsuming(this.activeRegularTransitions, queueConsumingActiveRegularTransitions, nonQueueConsumingActiveRegularTransitions);
        List<Transition<T>> nonQueueConsumingRegularCandidates = this.getTriggeredTransitions(nonQueueConsumingActiveRegularTransitions);
        List<Object> queueConsumingRegularCandidates = new ArrayList();
        List allQueueConsumingActiveTransitions = ListUtils.union(queueConsumingActiveSelfTransitions, queueConsumingActiveRegularTransitions);
        boolean queueConsumingSelfTransitionFollowed = false;
        if (allQueueConsumingActiveTransitions.isEmpty()) {
            this.queue.clear();
        } else {
            boolean foundIsResolveNow = false;
            for (Transition transition : allQueueConsumingActiveTransitions) {
                if (!transition.isResolveNow()) continue;
                foundIsResolveNow = true;
                break;
            }
            if (foundIsResolveNow) {
                do {
                    queueConsumingSelfTransitionFollowed = false;
                    for (Transition transition : this.getTriggeredTransitions(queueConsumingActiveSelfTransitions)) {
                        transition.onTransition();
                        queueConsumingSelfTransitionFollowed = true;
                    }
                    queueConsumingRegularCandidates = this.getTriggeredTransitions(queueConsumingActiveRegularTransitions);
                    if (!queueConsumingRegularCandidates.isEmpty()) break;
                    this.queue.poll();
                } while (!this.queue.isEmpty());
            }
        }
        Transition<T> t = this.chooseOneTransition(ListUtils.union(nonQueueConsumingRegularCandidates, queueConsumingRegularCandidates));
        this.rescheduleTransitions(this.activeSelfTransitions, false);
        if (t != null) {
            if (t.isTriggerQueueConsuming() || queueConsumingSelfTransitionFollowed) {
                this.queue.poll();
            }
            this.makeRegularTransition(t);
        } else {
            this.rescheduleTransitions(this.activeRegularTransitions, true);
        }
    }

    private Transition<T> chooseOneTransition(List<Transition<T>> transitions) {
        if (transitions.isEmpty()) {
            return null;
        }
        if (transitions.size() == 1) {
            return transitions.get(0);
        }
        switch (this.transitionResolutionStrategy) {
            case NATURAL: {
                return transitions.get(0);
            }
            case PRIORITY: {
                ArrayList<Transition<T>> temp = new ArrayList<Transition<T>>(transitions);
                SimUtilities.shuffle(temp, (Uniform)RandomHelper.getUniform());
                Collections.sort(temp, this.pComp);
                return (Transition)temp.get(0);
            }
            case RANDOM: {
                int size = transitions.size();
                Uniform defaultUniform = RandomHelper.getUniform();
                int index = defaultUniform.nextIntFromTo(0, size - 1);
                return transitions.get(index);
            }
        }
        throw new IllegalArgumentException();
    }

    private void rescheduleTransitions(List<Transition<T>> activeTransitions, boolean regular) {
        double currentTime = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
        if (regular) {
            for (Transition<T> t : activeTransitions) {
                t.rescheduleRegularTransition(this, currentTime);
            }
        } else {
            for (Transition<T> t : activeTransitions) {
                t.rescheduleSelfTransition(this, currentTime);
            }
        }
    }

    protected void scheduleResolveTime(double nextTime) {
        StateChartScheduler.INSTANCE.scheduleResolveTime(nextTime, this);
    }

    protected void removeResolveTime(double nextTime) {
        StateChartScheduler.INSTANCE.removeResolveTime(nextTime, this);
    }

    protected Queue<Object> getQueue() {
        return this.queue;
    }

    @Override
    public void receiveMessage(Object message) {
        this.queue.add(message);
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    protected void setPriority(double priority) {
        this.priority = priority;
    }

    @Override
    public T getAgent() {
        if (this.agent == null) {
            throw new IllegalStateException("The agent was not set in: " + this);
        }
        return this.agent;
    }

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    @Override
    public boolean withinState(String id) {
        List<AbstractState<T>> currentStates = this.getCurrentStates();
        for (AbstractState<T> s : currentStates) {
            if (!s.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<AbstractState<T>> getCurrentStates() {
        states = new ArrayList<AbstractState<T>>();
        s = this.getCurrentSimpleState();
        if (!(s instanceof FinalState)) ** GOTO lbl10
        states.add(s);
        return states;
lbl-1000:
        // 1 sources

        {
            states.add(s);
            s = s.getParent();
lbl10:
            // 2 sources

            ** while (s != null)
        }
lbl11:
        // 1 sources

        return states;
    }

    @Override
    public String getUuidForState(AbstractState<T> state) {
        String result = this.stateUuidMap.get(state);
        return result;
    }

    @Override
    public AbstractState<T> getStateForUuid(String uuid) {
        for (Map.Entry<AbstractState<T>, String> entry : this.stateUuidMap.entrySet()) {
            if (!entry.getValue().equals(uuid)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Transition<T> getTransitionForUuid(String uuid) {
        for (Map.Entry<Transition<T>, String> entry : this.transitionUuidMap.entrySet()) {
            if (!entry.getValue().equals(uuid)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void registerStateChartListener(StateChartListener scl) {
        this.stateChartListeners.add(scl);
    }

    @Override
    public void removeStateChartListener(StateChartListener scl) {
        this.stateChartListeners.remove(scl);
    }

    private void notifyChangeListeners() {
        for (StateChartListener scl : this.stateChartListeners) {
            scl.update();
        }
    }

    @Override
    public void activateState(AbstractState<T> state) {
        AbstractState simpleState = this.getCurrentSimpleState();
        if (simpleState != null) {
            AbstractState<T> lca = null;
            if (simpleState instanceof FinalState) {
                this.currentSimpleState = null;
            } else {
                lca = simpleState.calculateLowestCommonAncestor(state);
                List<AbstractState<T>> statesToExit = this.getStatesToExit(lca);
                this.currentSimpleState = null;
                for (AbstractState<T> as : statesToExit) {
                    this.clearTransitions(as);
                    as.onExit();
                }
            }
            List<AbstractState<T>> statesToEnter = this.getStatesToEnter(lca, state);
            this.stateInit(statesToEnter);
        }
    }

    @Override
    public void activateState(String stateID) {
        AbstractState<T> target = null;
        for (AbstractState<T> s : this.stateUuidMap.keySet()) {
            String id;
            if (s == null || (id = s.getId()) == null || !id.equals(stateID)) continue;
            target = s;
            break;
        }
        if (target != null) {
            this.activateState(target);
        }
    }

    @Override
    public void followTransition(String transitionID) {
        Transition<T> target = null;
        for (Transition<T> t : this.transitionUuidMap.keySet()) {
            String id;
            if (t == null || (id = t.getId()) == null || !id.equals(transitionID)) continue;
            target = t;
            break;
        }
        if (target != null) {
            this.followTransition(target);
        }
    }

    @Override
    public void followTransition(Transition<T> transition) {
        List<AbstractState<T>> currentStates = this.getCurrentStates();
        if (!currentStates.isEmpty() && currentStates.contains(transition.getSource())) {
            if (transition instanceof SelfTransition) {
                transition.onTransition();
            } else {
                this.makeRegularTransition(transition);
            }
        }
    }

    static class PriorityComparator<U>
    implements Comparator<Transition<U>> {
        PriorityComparator() {
        }

        @Override
        public int compare(Transition<U> t1, Transition<U> t2) {
            double index2;
            double index1 = t1.getPriority();
            return index1 < (index2 = t2.getPriority()) ? 1 : (index1 == index2 ? 0 : -1);
        }
    }
}

