/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.statecharts.StateChart;
import repast.simphony.statecharts.StateChartSimIntegrator;
import repast.simphony.util.ContextUtils;

public class DefaultIntegrator
implements StateChartSimIntegrator,
ContextListener<Object> {
    private List<Element> elements = new ArrayList<Element>();

    private void addChart(Context<Object> context, StateChart<?> chart) {
        List<StateChart<?>> charts;
        Object agent = chart.getAgent();
        Element element = this.findElement(context);
        if (element == null) {
            element = new Element();
            this.elements.add(element);
            element.context = context;
            context.addContextListener((ContextListener)this);
        }
        if ((charts = element.chartMap.get(agent)) == null) {
            charts = new ArrayList();
            element.chartMap.put(agent, charts);
        }
        charts.add(chart);
    }

    private Element findElement(Context<?> context) {
        for (Element element : this.elements) {
            if (!context.equals(element.context)) continue;
            return element;
        }
        return null;
    }

    @Override
    public boolean integrate(StateChart<?> chart) {
        Context context = ContextUtils.getContext(chart.getAgent());
        if (context == null) {
            return false;
        }
        this.addChart((Context<Object>)context, chart);
        return true;
    }

    @Override
    public void reset() {
        for (Element element : this.elements) {
            element.context.removeContextListener((ContextListener)this);
        }
        this.elements.clear();
    }

    public void eventOccured(ContextEvent<Object> ev) {
        if (ev.getType() == ContextEvent.EventType.AGENT_REMOVED) {
            Element element = this.findElement(ev.getContext());
            List<StateChart<?>> charts = element.chartMap.remove(ev.getTarget());
            if (charts != null) {
                for (StateChart<?> chart : charts) {
                    chart.stop();
                }
            }
        }
    }

    private static class Element {
        Context<Object> context;
        Map<Object, List<StateChart<?>>> chartMap = new HashMap();

        private Element() {
        }
    }
}

