/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.parameter.Parameters;
import repast.simphony.statecharts.AbstractTrigger;
import repast.simphony.statecharts.ConditionTriggerCondition;
import simphony.util.messages.MessageCenter;

public class ConditionTrigger<T>
extends AbstractTrigger<T> {
    private double pollingTime;
    private double nextPollingTime;
    private double initializedTickCount;
    private ConditionTriggerCondition<T> condition;
    private Parameters params;

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    public ConditionTrigger(ConditionTriggerCondition<T> condition, double pollingTime) {
        this.pollingTime = pollingTime;
        this.nextPollingTime = pollingTime;
        this.condition = condition;
    }

    public ConditionTrigger(ConditionTriggerCondition<T> condition) {
        this(condition, 1.0);
    }

    @Override
    public boolean isRecurring() {
        return true;
    }

    @Override
    public double getInterval() {
        return this.pollingTime;
    }

    @Override
    public void setInterval(double interval) {
        this.nextPollingTime = interval;
    }

    @Override
    public void initialize() {
        this.pollingTime = this.nextPollingTime;
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        this.initializedTickCount = schedule.getTickCount();
    }

    @Override
    public double getNextTime() {
        return this.initializedTickCount + this.pollingTime;
    }

    @Override
    public boolean isTriggered() {
        double now = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
        return Double.compare(now, this.getNextTime()) >= 0 && this.isTriggerConditionTrue();
    }

    @Override
    public boolean isTriggerConditionTrue() {
        boolean result = false;
        try {
            result = this.condition.condition(this.getAgent(), this.transition, this.getParams());
        }
        catch (Exception e) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when calling condition: " + this.condition + " in " + this), (Throwable)e, new Object[0]);
        }
        return result;
    }

    public String toString() {
        return "ConditionTrigger with pollingTime: " + this.pollingTime;
    }

    @Override
    public boolean canTransitionZeroTime() {
        return true;
    }
}

