/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import repast.simphony.parameter.IllegalParameterException;
import repast.simphony.statecharts.AbstractState;
import repast.simphony.statecharts.AbstractStateBuilder;
import repast.simphony.statecharts.CompositeState;
import repast.simphony.statecharts.HistoryState;

public class CompositeStateBuilder<T>
extends AbstractStateBuilder<T> {
    private List<AbstractState<T>> children = new ArrayList<AbstractState<T>>();
    private List<HistoryState<T>> historyStates = new ArrayList<HistoryState<T>>();
    private AbstractState<T> entryState;
    private Map<AbstractState<T>, String> stateUuidMap = new LinkedHashMap<AbstractState<T>, String>();

    public CompositeStateBuilder(String id, AbstractState<T> entryState) {
        this(id, entryState, null);
    }

    public CompositeStateBuilder(String id, AbstractState<T> entryState, String entryStateUuid) {
        super(id);
        this.registerEntryState(entryState, entryStateUuid);
    }

    public void addChildState(AbstractState<T> state) {
        this.addChildState(state, null);
    }

    public void addChildState(AbstractState<T> state, String uuid) {
        if (state instanceof HistoryState) {
            throw new IllegalParameterException("Add HistoryStates using the addHistoryState(s) method(s).");
        }
        if (!this.children.contains(state)) {
            this.children.add(state);
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
            }
            this.stateUuidMap.put(state, uuid);
        }
    }

    public void addAllChildStates(List<AbstractState<T>> states) {
        for (AbstractState<T> state : states) {
            this.addChildState(state, null);
        }
    }

    private void registerEntryState(AbstractState<T> state, String uuid) {
        this.entryState = state;
        this.addChildState(state, uuid);
    }

    public void addHistoryState(HistoryState<T> historyState) {
        this.addHistoryState(historyState, null);
    }

    public void addHistoryState(HistoryState<T> historyState, String uuid) {
        if (!this.historyStates.contains(historyState)) {
            this.historyStates.add(historyState);
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
            }
            this.stateUuidMap.put(historyState, uuid);
        }
    }

    public CompositeState<T> build() {
        if (this.entryState == null) {
            throw new IllegalStateException("All CompositeStates must register an entry state.");
        }
        CompositeState result = new CompositeState(this.id);
        this.setAbstractProperties(result);
        result.registerEntryState(this.entryState);
        for (AbstractState<T> abstractState : this.children) {
            result.add(abstractState);
        }
        for (HistoryState historyState : this.historyStates) {
            result.addHistoryState(historyState);
        }
        result.setStateUuidMap(this.stateUuidMap);
        for (AbstractState<T> abstractState : this.children) {
            if (!(abstractState instanceof CompositeState)) continue;
            CompositeState compositeState = (CompositeState)abstractState;
            Map map = compositeState.getStateUuidMap();
            for (Map.Entry entry : map.entrySet()) {
                result.putStateUuid(entry.getKey(), entry.getValue());
            }
            compositeState.clearStateUuidMap();
        }
        return result;
    }
}

