/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.statecharts.AbstractTrigger;

public class AlwaysTrigger
extends AbstractTrigger<Object> {
    private double pollingTime;
    private double nextPollingTime;
    private double initializedTickCount;

    public AlwaysTrigger() {
        this(1.0);
    }

    public AlwaysTrigger(double pollingTime) {
        this.pollingTime = pollingTime;
        this.nextPollingTime = pollingTime;
    }

    @Override
    public void initialize() {
        this.pollingTime = this.nextPollingTime;
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        this.initializedTickCount = schedule.getTickCount();
    }

    @Override
    public boolean isTriggered() {
        return this.isTriggerConditionTrue();
    }

    @Override
    public boolean isTriggerConditionTrue() {
        return true;
    }

    @Override
    public boolean isRecurring() {
        return true;
    }

    @Override
    public double getInterval() {
        return this.pollingTime;
    }

    @Override
    public double getNextTime() {
        return this.initializedTickCount + this.getInterval();
    }

    @Override
    public boolean canTransitionZeroTime() {
        return true;
    }

    @Override
    public void setInterval(double interval) {
        this.nextPollingTime = interval;
    }
}

