/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.statecharts;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.parameter.Parameters;
import repast.simphony.statecharts.CompositeState;
import repast.simphony.statecharts.DefaultStateChart;
import repast.simphony.statecharts.StateAction;
import simphony.util.messages.MessageCenter;

public abstract class AbstractState<T> {
    private DefaultStateChart<T> stateChart;
    private T agent;
    private CompositeState<T> parent;
    private String id;
    private StateAction<T> onEnter;
    private StateAction<T> onExit;
    private Parameters params;

    protected T getAgent() {
        if (this.agent == null) {
            if (this.stateChart == null) {
                if (this.getParent() == null) {
                    throw new IllegalStateException("The state: " + this + " was not added to the statechart");
                }
                this.agent = this.getParent().getAgent();
            } else {
                this.agent = this.stateChart.getAgent();
            }
        }
        return this.agent;
    }

    protected void setStateChart(DefaultStateChart<T> stateChart) {
        this.stateChart = stateChart;
    }

    public CompositeState<T> getParent() {
        return this.parent;
    }

    public void setParent(CompositeState<T> parent) {
        this.parent = parent;
    }

    public AbstractState(String id) {
        this.id = id;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    protected Parameters getParams() {
        RunEnvironment re;
        if (this.params == null && (re = RunEnvironment.getInstance()) != null) {
            this.params = re.getParameters();
        }
        return this.params;
    }

    protected void onEnter() {
        try {
            this.onEnter.action(this.getAgent(), this, this.getParams());
        }
        catch (Exception e) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when calling onEnter in state: " + this.id), (Throwable)e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    protected void onExit() {
        try {
            this.onExit.action(this.getAgent(), this, this.getParams());
        }
        catch (Exception e) {
            MessageCenter.getMessageCenter(this.getClass()).error((Object)("Error encountered when calling onExit in state: " + this.id), (Throwable)e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    protected void registerOnEnter(StateAction<T> onEnter) {
        this.onEnter = onEnter;
    }

    protected void registerOnExit(StateAction<T> onExit) {
        this.onExit = onExit;
    }

    public AbstractState<T> calculateLowestCommonAncestor(AbstractState<T> other) {
        if (this.equals(other)) {
            return this.getParent();
        }
        Iterator<AbstractState<T>> myAncestors = this.getAncestors().iterator();
        Iterator<AbstractState<T>> otherAncestors = other.getAncestors().iterator();
        AbstractState<T> currentCandidate = null;
        while (myAncestors.hasNext() && otherAncestors.hasNext()) {
            AbstractState<T> myNext = myAncestors.next();
            if (myNext != otherAncestors.next()) continue;
            currentCandidate = myNext;
        }
        return currentCandidate;
    }

    protected List<AbstractState<T>> getAncestors() {
        LinkedList<AbstractState<T>> ancestors = new LinkedList<AbstractState<T>>();
        CompositeState<T> s = this;
        ancestors.addFirst(s);
        while (s.getParent() != null) {
            s = s.getParent();
            ancestors.addFirst(s);
        }
        return ancestors;
    }
}

