/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.sql;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;
import org.josql.contrib.JoSQLSwingTableModel;
import org.jscience.physics.amount.Amount;
import repast.simphony.context.Context;
import repast.simphony.engine.environment.RunState;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.sql.RepastJoSQLFunctionHandler;
import repast.simphony.ui.filters.FileExtensionFilter;
import repast.simphony.ui.sparkline.SparklineJComponent;
import repast.simphony.ui.table.TablePanel;

public class SQLWindow
extends JPanel {
    public String currentSource = "";
    public Map<String, Object> sourceMap = new HashMap<String, Object>();
    public static final String NO_SPARKLINE = "No Sparkline          ";
    private JLabel label1;
    private JComboBox sourceComboBox;
    private JLabel label2;
    private JLabel label3;
    private JPanel panel1;
    private JButton executeButton;
    private JButton exportButton;
    private JScrollPane scrollPane2;
    private JTextArea queryTextArea;
    private JScrollPane scrollPane3;
    private JTextArea messageTextArea;
    private JLabel label4;
    private JTextField functionHandlerTextField;
    private JComboBox sparklineComboBox;
    private SparklineJComponent sparklineJComponent;
    private TablePanel tablePanel;

    public SQLWindow() {
        this.initComponents();
        this.sparklineJComponent.setLineGraph(true);
        this.tablePanel.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SQLWindow.this.redrawSparkline();
            }
        });
        this.sparklineComboBox.addItem(NO_SPARKLINE);
        this.findSources();
        ArrayList<String> sortedList = new ArrayList<String>(this.sourceMap.keySet());
        Collections.sort(sortedList);
        for (String key : sortedList) {
            this.sourceComboBox.addItem(key);
        }
        this.queryTextArea.setText("/* Queries use JoSQL (http://josql.sourceforge.net/index.html) " + System.getProperty("line.separator") + " for execution. Please see their web site for instructions. */" + System.getProperty("line.separator") + "SELECT toString Name, class.name Class, propertyNames(:_currobj) Properties, " + "propertyValues(:_currobj) Values" + System.getProperty("line.separator") + "FROM java.lang.Object");
    }

    public void findSources() {
        Context mainContext = RunState.getInstance().getMasterContext();
        String pathName = mainContext.getId().toString();
        this.sourceMap.put("Context (Main): " + pathName, mainContext);
        this.findSources(String.valueOf(pathName) + "/", mainContext);
    }

    public void findSources(String pathName, Context context) {
        String childPathName;
        for (Object childObject : context.getSubContexts()) {
            if (!(childObject instanceof Context)) continue;
            Context childContext = (Context)childObject;
            childPathName = String.valueOf(pathName) + childContext.getId().toString();
            this.sourceMap.put("Context: " + childPathName, childContext);
            this.findSources(String.valueOf(childPathName) + "/", childContext);
        }
        for (Object childObject : context.getProjections()) {
            if (!(childObject instanceof Network)) continue;
            Network childNetwork = (Network)childObject;
            childPathName = String.valueOf(pathName) + childNetwork.getName();
            this.sourceMap.put("Network: " + childPathName, childNetwork);
        }
    }

    private void executeButtonActionPerformed(ActionEvent e) {
        try {
            this.messageTextArea.setText("");
            JoSQLSwingTableModel model = new JoSQLSwingTableModel();
            model.setClassLoader(this.getClass().getClassLoader());
            model.addFunctionHandler(new RepastJoSQLFunctionHandler());
            String functionHandlerClassName = this.functionHandlerTextField.getText();
            if (functionHandlerClassName != null && !functionHandlerClassName.equals("")) {
                try {
                    Class<?> functionHandlerClass = Class.forName(functionHandlerClassName);
                    model.addFunctionHandler(functionHandlerClass.newInstance());
                }
                catch (Exception eFH) {
                    this.messageTextArea.setText(String.valueOf(this.messageTextArea.getText()) + "Could not load function handler: " + eFH.getLocalizedMessage());
                }
            }
            model.parse(this.queryTextArea.getText());
            ArrayList list = new ArrayList();
            Object source = this.sourceMap.get(this.sourceComboBox.getSelectedItem());
            Object sourceList = null;
            if (source instanceof Context) {
                sourceList = ((Context)source).getObjects(model.getFromObjectClass());
            } else if (source instanceof Network) {
                sourceList = ((Network)source).getEdges();
                if (!Network.class.isAssignableFrom(model.getFromObjectClass())) {
                    model.setFromObjectClass(RepastEdge.class);
                }
            }
            if (source == null) {
                this.messageTextArea.setText(String.valueOf(this.messageTextArea.getText()) + " Invalid source. Please select another source.");
            } else {
                Class fromClass = model.getFromObjectClass();
                Iterator iterator = sourceList.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj == null || !fromClass.isAssignableFrom(obj.getClass())) continue;
                    list.add(obj);
                }
            }
            QueryResults results = model.execute(list);
            this.tablePanel.getTable().setModel(model);
            Map saveValue = results.getSaveValues();
            if (saveValue != null && saveValue.size() > 0) {
                String message = "";
                Object value = null;
                for (Object key : saveValue.keySet()) {
                    value = saveValue.get(key);
                    message = String.valueOf(message) + key + " = " + value + System.getProperty("line.separator");
                }
                this.messageTextArea.setText(String.valueOf(this.messageTextArea.getText()) + " " + message);
            }
            if (model != null) {
                this.sparklineComboBox.removeAllItems();
                this.sparklineComboBox.addItem(NO_SPARKLINE);
                this.sparklineComboBox.setSelectedItem(NO_SPARKLINE);
                int col = 0;
                while (col < model.getColumnCount()) {
                    this.sparklineComboBox.addItem("Sparkline for " + model.getColumnName(col));
                    ++col;
                }
            }
        }
        catch (QueryParseException e2) {
            this.messageTextArea.setText(String.valueOf(this.messageTextArea.getText()) + " " + e2.getMessage());
        }
        catch (QueryExecutionException e3) {
            this.messageTextArea.setText(String.valueOf(this.messageTextArea.getText()) + " " + e3.getMessage());
        }
    }

    private void exportButtonActionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(new File("results.csv"));
        FileExtensionFilter filter = new FileExtensionFilter("CSV", new String[]{"csv"});
        chooser.setFileFilter((FileFilter)filter);
        if (chooser.showSaveDialog(this.getTopLevelAncestor()) == 0) {
            try {
                PrintWriter writer = new PrintWriter(chooser.getSelectedFile());
                TableModel model = this.tablePanel.getTable().getModel();
                int col = 0;
                while (col < model.getColumnCount()) {
                    writer.print(model.getColumnName(col));
                    if (col < model.getColumnCount() - 1) {
                        writer.print(", ");
                    } else {
                        writer.println();
                    }
                    ++col;
                }
                int row = 0;
                while (row < model.getRowCount()) {
                    int col2 = 0;
                    while (col2 < model.getColumnCount()) {
                        writer.print(model.getValueAt(row, col2));
                        if (col2 < model.getColumnCount() - 1) {
                            writer.print(", ");
                        } else {
                            writer.println();
                        }
                        ++col2;
                    }
                    ++row;
                }
                writer.close();
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(null, "Error" + e1.getMessage());
            }
        }
    }

    private void sourceComboBoxActionPerformed(ActionEvent e) {
        String selectedItem = (String)this.sourceComboBox.getSelectedItem();
        if (selectedItem != null && !selectedItem.equals(this.currentSource)) {
            this.currentSource = selectedItem;
        }
    }

    private void sparklineComboBoxActionPerformed(ActionEvent e) {
        this.redrawSparkline();
    }

    public void redrawSparkline() {
        int col = this.sparklineComboBox.getSelectedIndex() - 1;
        TableModel model = this.tablePanel.getTable().getModel();
        if (col >= 0 && model.getRowCount() > 0) {
            Number[] newData = new Number[model.getRowCount()];
            int row = 0;
            while (row < model.getRowCount()) {
                try {
                    Object value = model.getValueAt(row, col);
                    newData[row] = value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : (value instanceof Amount ? Double.valueOf(((Amount)value).getEstimatedValue()) : (value instanceof String ? Double.valueOf(Double.parseDouble((String)value)) : Double.valueOf(0.0)));
                }
                catch (Exception ex) {
                    newData[row] = 0.0;
                }
                ++row;
            }
            this.sparklineJComponent.setData(newData);
        } else {
            this.sparklineJComponent.clearData();
        }
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.sourceComboBox = new JComboBox();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.panel1 = new JPanel();
        this.executeButton = new JButton();
        this.exportButton = new JButton();
        this.scrollPane2 = new JScrollPane();
        this.queryTextArea = new JTextArea();
        this.scrollPane3 = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.label4 = new JLabel();
        this.functionHandlerTextField = new JTextField();
        this.sparklineComboBox = new JComboBox();
        this.sparklineJComponent = new SparklineJComponent();
        this.tablePanel = new TablePanel();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 0.0)}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}));
        this.label1.setText("Source Container:");
        this.label1.setHorizontalAlignment(4);
        this.add((Component)this.label1, cc.xy(1, 1));
        this.sourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLWindow.this.sourceComboBoxActionPerformed(e);
            }
        });
        this.add((Component)this.sourceComboBox, cc.xywh(3, 1, 3, 1));
        this.label2.setText("Query");
        this.label2.setHorizontalAlignment(0);
        this.add((Component)this.label2, cc.xy(3, 3));
        this.label3.setText("Message");
        this.label3.setHorizontalAlignment(0);
        this.add((Component)this.label3, cc.xy(5, 3));
        this.panel1.setLayout((LayoutManager)new FormLayout(ColumnSpec.decodeSpecs((String)"default"), new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.executeButton.setText("Execute Query");
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLWindow.this.executeButtonActionPerformed(e);
            }
        });
        this.panel1.add((Component)this.executeButton, cc.xy(1, 1));
        this.exportButton.setText("Export to CSV");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLWindow.this.exportButtonActionPerformed(e);
            }
        });
        this.panel1.add((Component)this.exportButton, cc.xy(1, 3));
        this.add((Component)this.panel1, cc.xy(1, 5));
        this.queryTextArea.setColumns(75);
        this.queryTextArea.setRows(10);
        this.queryTextArea.setFont(new Font("Tahoma", 0, 11));
        this.queryTextArea.setLineWrap(true);
        this.scrollPane2.setViewportView(this.queryTextArea);
        this.add((Component)this.scrollPane2, cc.xy(3, 5));
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setColumns(50);
        this.messageTextArea.setRows(10);
        this.messageTextArea.setFont(new Font("Tahoma", 0, 11));
        this.messageTextArea.setLineWrap(true);
        this.scrollPane3.setViewportView(this.messageTextArea);
        this.add((Component)this.scrollPane3, cc.xy(5, 5));
        this.label4.setText("Function Handler:");
        this.add((Component)this.label4, cc.xywh(1, 7, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.add((Component)this.functionHandlerTextField, cc.xywh(3, 7, 3, 1));
        this.sparklineComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLWindow.this.sparklineComboBoxActionPerformed(e);
            }
        });
        this.add((Component)this.sparklineComboBox, cc.xy(1, 9));
        this.add((Component)this.sparklineJComponent, cc.xywh(3, 9, 3, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.add((Component)this.tablePanel, cc.xywh(1, 11, 5, 1));
    }
}

