/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.score;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Test;
import repast.simphony.filter.OrFilter;
import repast.simphony.parameter.StringConverterFactory;
import repast.simphony.scenario.data.Attribute;
import repast.simphony.scenario.data.Classpath;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.ContextFileReader;
import repast.simphony.scenario.data.ContextFileWriter;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.scenario.data.UserPathData;
import repast.simphony.scenario.data.UserPathFileReader;
import repast.simphony.score.TestAttributeType;
import repast.simphony.util.ClassPathEntry;
import repast.simphony.util.ClassPathFilter;

public class ReaderTests {
    @Test
    public void pkgFilterTests() {
        ClassPathFilter filter = new ClassPathFilter("foo.bar.*");
        String path = this.makeClass("java", "lang", "String");
        Assert.assertFalse((String)path, (boolean)filter.evaluate(path));
        path = this.makeClass("foo", "bar", "Util");
        Assert.assertTrue((String)path, (boolean)filter.evaluate(path));
        filter = new ClassPathFilter("foo.bar.Util");
        path = this.makeClass("foo", "bar", "Util");
        Assert.assertTrue((String)path, (boolean)filter.evaluate(path));
        filter = new ClassPathFilter("foo.bar.Util");
        path = "foo2bar2Util.class";
        Assert.assertFalse((String)path, (boolean)filter.evaluate(path));
        filter = new ClassPathFilter("*SimpleAgent");
        path = "anl/gov/SimpleAgent.class";
        Assert.assertTrue((String)path, (boolean)filter.evaluate(path));
        filter = new ClassPathFilter("*SimpleAgent");
        path = "anl/gov/Agent.class";
        Assert.assertFalse((String)path, (boolean)filter.evaluate(path));
        filter = new ClassPathFilter("*SimpleAgent");
        path = "anl/gov/SimpleAgent2";
        Assert.assertFalse((String)path, (boolean)filter.evaluate(path));
    }

    private String makeClass(String ... parts) {
        StringBuilder buf = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            buf.append(val);
            buf.append(File.separator);
            ++n2;
        }
        return String.valueOf(buf.toString().substring(0, buf.length() - 1)) + ".class";
    }

    @Test
    public void testModelFileReader() throws IOException, XMLStreamException {
        UserPathFileReader reader = new UserPathFileReader();
        File modelFile = new File("./test/data/model.xml");
        UserPathData data = reader.read(modelFile);
        Assert.assertEquals((Object)"Test Model", (Object)data.getName());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(new File(modelFile.getParentFile().getParentFile(), "bin").getCanonicalPath());
        expected.add("/model/groovy-bin");
        expected.add(new File(modelFile.getParentFile(), "lib/foo.jar").getCanonicalPath());
        expected.add(new File(modelFile.getParentFile().getParentFile(), "lib/bar.jar").getCanonicalPath());
        expected.add("/foo.jar");
        expected.add("/lib/agent.jar");
        expected.add("/lib/more.jar");
        int i = 0;
        for (ClassPathEntry entry : data.classpathEntries()) {
            Assert.assertEquals(expected.get(i++), (Object)entry.getPath().getCanonicalPath());
        }
        expected.clear();
        expected.add(new File(modelFile.getParentFile(), "lib/foo.jar").getCanonicalPath());
        expected.add(new File(modelFile.getParentFile().getParentFile(), "lib/bar.jar").getCanonicalPath());
        expected.add("/lib/agent.jar");
        expected.add("/lib/more.jar");
        i = 0;
        for (ClassPathEntry entry : data.annotationCPEntries()) {
            Assert.assertEquals(expected.get(i++), (Object)entry.getPath().getCanonicalPath());
        }
        Assert.assertEquals((long)4L, (long)i);
        Assert.assertEquals((long)2L, (long)data.getAgentEntryCount());
        Iterator<ClassPathEntry> iter = data.agentEntries().iterator();
        ClassPathEntry agentPath = iter.next();
        Assert.assertEquals((Object)new File("/lib/agent.jar").getCanonicalPath(), (Object)agentPath.getPath().getCanonicalPath());
        Assert.assertTrue((boolean)agentPath.filter("asdfa;lkjae;lkrja;sdflkj"));
        agentPath = iter.next();
        Assert.assertEquals((Object)new File("/lib/more.jar").getCanonicalPath(), (Object)agentPath.getPath().getCanonicalPath());
        Iterator fiter = ((OrFilter)agentPath.getFilter()).filters().iterator();
        ClassPathFilter cpFilter = (ClassPathFilter)fiter.next();
        Assert.assertEquals((Object)"foo\\.bar\\.\\w*\\.class", (Object)cpFilter.getPattern());
        cpFilter = (ClassPathFilter)fiter.next();
        Assert.assertEquals((Object)"baz\\.bar\\.\\w*\\.class", (Object)cpFilter.getPattern());
    }

    private void testContext(ContextData data) {
        ProjectionData pData;
        String[][] pExpected = new String[][]{{"p_1", "NETWORK"}, {"p_2", "GRID"}, {"p_3", "NETWORK"}, {"p_4", "GRID"}, {"p_5", "NETWORK"}, {"p_6", "GRID"}, {"p_7", "CONTINUOUS_SPACE"}, {"p_8", "GEOGRAPHY"}, {"p_9", "NETWORK"}, {"p_10", "GRID"}, {"p_11", "CONTINUOUS_SPACE"}, {"p_12", "GEOGRAPHY"}};
        Assert.assertEquals((Object)"root", (Object)data.getId());
        Assert.assertEquals((long)2L, (long)data.getProjectionCount());
        int i = 0;
        while (i < 2) {
            ProjectionData pData2 = data.getProjection(i);
            Assert.assertEquals((Object)pExpected[i][0], (Object)pData2.getId());
            Assert.assertEquals((Object)pExpected[i][1], (Object)pData2.getType().toString());
            Assert.assertEquals((long)0L, (long)pData2.getAttributeCount());
            ++i;
        }
        Assert.assertEquals(null, (Object)data.getContextClassName());
        Assert.assertEquals((long)2L, (long)data.getAttributeCount());
        Iterator<Attribute> aIter = data.attributes().iterator();
        Attribute a1 = aIter.next();
        Assert.assertEquals((Object)"a1", (Object)a1.getId());
        Assert.assertEquals((Object)"a1", (Object)a1.getDisplayName());
        Assert.assertEquals((Object)"Hello", (Object)a1.getValue());
        Assert.assertEquals(String.class, a1.getType());
        Assert.assertEquals((Object)StringConverterFactory.instance().getConverter(String.class), (Object)a1.getConverter());
        Attribute a2 = aIter.next();
        Assert.assertEquals((Object)"a2", (Object)a2.getId());
        Assert.assertEquals((Object)"attribute 2", (Object)a2.getDisplayName());
        Assert.assertEquals((Object)"Foo", (Object)a2.getValue());
        Assert.assertEquals(TestAttributeType.class, a2.getType());
        Assert.assertEquals((Object)"repast.simphony.score.TestConverter", (Object)a2.getConverter().getClass().getName());
        Assert.assertEquals((long)2L, (long)data.getSubContextCount());
        ContextData child = data.getSubContext(0);
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)"child", (Object)child.getId());
        Assert.assertEquals((long)2L, (long)child.getProjectionCount());
        Assert.assertEquals((long)0L, (long)child.getAttributeCount());
        int i2 = 0;
        while (i2 < 2) {
            pData = child.getProjection(i2);
            Assert.assertEquals((Object)pExpected[i2 + 2][0], (Object)pData.getId());
            Assert.assertEquals((Object)pExpected[i2 + 2][1], (Object)pData.getType().toString());
            if (pData.getId().equals("p_4")) {
                Assert.assertEquals((long)1L, (long)pData.getAttributeCount());
                Attribute pAttrib = pData.attributes().iterator().next();
                Assert.assertEquals((Object)"p_4_height", (Object)pAttrib.getId());
                Assert.assertEquals((Object)"p_4_height", (Object)pAttrib.getDisplayName());
                Assert.assertEquals((Object)"30", (Object)pAttrib.getValue());
                Assert.assertEquals(Integer.TYPE, pAttrib.getType());
                Assert.assertEquals((Object)StringConverterFactory.instance().getConverter(Integer.TYPE), (Object)pAttrib.getConverter());
            } else {
                Assert.assertEquals((long)0L, (long)pData.getAttributeCount());
            }
            ++i2;
        }
        Assert.assertEquals((long)0L, (long)child.getSubContextCount());
        child = data.getSubContext(1);
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)"child2", (Object)child.getId());
        Assert.assertEquals((Object)"anl.gov.MyContext", (Object)child.getContextClassName());
        Assert.assertEquals((long)4L, (long)child.getProjectionCount());
        Assert.assertEquals((long)0L, (long)child.getAttributeCount());
        i2 = 0;
        while (i2 < 4) {
            pData = child.getProjection(i2);
            Assert.assertEquals((long)0L, (long)pData.getAttributeCount());
            Assert.assertEquals((Object)pExpected[i2 + 4][0], (Object)pData.getId());
            Assert.assertEquals((Object)pExpected[i2 + 4][1], (Object)pData.getType().toString());
            ++i2;
        }
        Assert.assertEquals((long)0L, (long)child.getAgentCount());
        Assert.assertEquals((long)1L, (long)child.getSubContextCount());
        child = child.getSubContext(0);
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)"grand_child", (Object)child.getId());
        Assert.assertEquals(null, (Object)child.getContextClassName());
        Assert.assertEquals((long)4L, (long)child.getProjectionCount());
        i2 = 0;
        while (i2 < 4) {
            pData = child.getProjection(i2);
            Assert.assertEquals((Object)pExpected[i2 + 8][0], (Object)pData.getId());
            Assert.assertEquals((Object)pExpected[i2 + 8][1], (Object)pData.getType().toString());
            ++i2;
        }
        Assert.assertEquals((long)0L, (long)child.getSubContextCount());
    }

    @Test
    public void testContextFileReader() throws IOException, XMLStreamException {
        ContextFileReader reader = new ContextFileReader();
        File contextFile = new File("./test/data/context.xml");
        ContextData data = reader.read(contextFile, new Classpath());
        Assert.assertNotNull((Object)data);
        this.testContext(data);
    }

    @Test
    public void testContextFileWriter() throws IOException, XMLStreamException {
        ContextFileReader reader = new ContextFileReader();
        File contextFile = new File("./test/data/context.xml");
        ContextData data = reader.read(contextFile, new Classpath());
        Assert.assertNotNull((Object)data);
        ContextFileWriter writer = new ContextFileWriter();
        File copy = new File("./test/data/context_copy.xml");
        writer.write(copy, data);
        data = reader.read(copy, new Classpath());
        Assert.assertNotNull((Object)data);
        this.testContext(data);
    }

    private Set<String> toSet(String[] vals) {
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            set.add(val);
            ++n2;
        }
        return set;
    }

    @Test
    public void testClasspath() {
        String[] expected1 = new String[]{"dockingFrames-1.0.8p2.jar", "dockingFrames-1.0.8p3a-saf.jar", "dockingFrames-1.0.6.jar", "forms-1.0.5.jar", "jh.jar", "l2fprod-common-all.jar", "osx.jar", "TableLayout.jar", "wizard-0.1.12.jar", "bin", "colt-1.2.0.jar"};
        Classpath cp = new Classpath();
        Assert.assertTrue((boolean)cp.addEntry("../saf.core.ui/lib"));
        Assert.assertTrue((boolean)cp.addEntry("../repast.simphony.core/bin/"));
        Assert.assertTrue((boolean)cp.addEntry("../repast.simphony.core/lib/colt-1.2.0.jar"));
        Set<String> expected = this.toSet(expected1);
        for (File path : cp.classPaths()) {
            Assert.assertTrue((String)path.getName(), (boolean)expected.remove(path.getName()));
        }
        Assert.assertEquals((long)0L, (long)expected.size());
        Assert.assertTrue((!cp.addEntry("../foo") ? 1 : 0) != 0);
    }

    @Test
    public void testFindClasses() throws IOException, ClassNotFoundException {
        String[] expectedArray = new String[]{"saf.core.runtime.Boot$1", "saf.core.runtime.Boot$Restriction", "saf.core.runtime.Boot", "saf.core.runtime.CorePlugin", "saf.core.runtime.IApplicationRunnable", "saf.core.runtime.PluginAttributes", "saf.core.runtime.PluginDefinitionException", "saf.core.runtime.PluginReader", "saf.core.runtime.SimpleAttribute", "simphony.settings.SettingsIO", "simphony.settings.SettingsRegistry", "simphony.util.Main", "simphony.util.ThreadUtilities$1", "simphony.util.ThreadUtilities$Runner", "simphony.util.ThreadUtilities", "simphony.util.error.ErrorCenter", "simphony.util.error.ErrorEvent", "simphony.util.error.ErrorHandler", "simphony.util.messages.AbstractMessageListener", "simphony.util.messages.Log4jMessageListener", "simphony.util.messages.MessageCenter", "simphony.util.messages.MessageCenterLayout", "simphony.util.messages.MessageEvent", "simphony.util.messages.MessageEventListener", "simphony.util.messages.NullTaskMessage", "simphony.util.messages.StackTaskMessageListener", "simphony.util.messages.TaskMessage$TaskStatus", "simphony.util.messages.TaskMessage", "simphony.util.messages.TaskMessageCallback", "simphony.util.messages.TaskMessageListener", "repast.simphony.plugin.ExtendablePluginClassLoader", "repast.simphony.plugin.PluginLifecycleHandler", "repast.simphony.runtime.RepastMain", "repast.simphony.ant.BuildPluginClasspath$1", "repast.simphony.ant.BuildPluginClasspath", "repast.simphony.ant.BuildPluginClasspath$NameExtractor", "repast.simphony.ant.DummyEntityResolver", "repast.simphony.ant.PluginDescriptor", "repast.simphony.ant.PluginHandler", "repast.simphony.ant.PluginLibHandler", "repast.simphony.ant.PluginList"};
        Set<String> expected = this.toSet(expectedArray);
        Classpath cp = new Classpath();
        Assert.assertTrue((boolean)cp.addEntry("../repast.simphony.runtime/lib/saf.core.runtime.jar"));
        Assert.assertTrue((boolean)cp.addEntry("../repast.simphony.runtime/bin"));
        List<Class<?>> classes = cp.getClasses();
        for (Class<?> clazz : classes) {
            Assert.assertTrue((String)clazz.getName(), (boolean)expected.remove(clazz.getName()));
        }
        Assert.assertEquals((long)0L, (long)expected.size());
    }
}

