/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import repast.simphony.scenario.data.UserPathData;

public class UserPathFileReader {
    private static final String MODEL_E = "model";
    private static final String ENTRY_E = "entry";
    private static final String AGENT_E = "agents";
    private static final String BUILTIN_E = "builtin";
    private static final String LIST_SEPARATOR = ",";
    private static final QName NAME_A = new QName("name");
    private static final QName PATH_A = new QName("path");
    private static final QName FILTER_A = new QName("filter");
    private static final QName ANNOTATION_A = new QName("annotations");
    private static final QName FULLNAME_A = new QName("fullname");
    private static final String LIB_PATH = "../lib";

    public UserPathData read(File file) throws IOException, XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(new BufferedReader(new FileReader(file)));
        UserPathData data = null;
        while (reader.hasNext()) {
            XMLEvent evt = reader.nextEvent();
            if (!evt.isStartElement()) continue;
            StartElement elmt = evt.asStartElement();
            String qName = elmt.getName().getLocalPart();
            if (qName.equals(MODEL_E)) {
                Attribute attrib = elmt.getAttributeByName(NAME_A);
                data = new UserPathData(attrib.getValue());
                continue;
            }
            if (qName.equals(ENTRY_E)) {
                this.processEntry(elmt, data, file);
                continue;
            }
            if (qName.equals(AGENT_E)) {
                this.processAgent(elmt, data, file);
                continue;
            }
            if (!qName.equals(BUILTIN_E)) continue;
            this.processBuiltin(elmt, data, file);
        }
        return data;
    }

    private void processAgent(StartElement elmt, UserPathData data, File modelFile) throws IOException {
        StringTokenizer tok;
        Attribute entry = elmt.getAttributeByName(PATH_A);
        Attribute pkg = elmt.getAttributeByName(FILTER_A);
        ArrayList<String> pkgFilters = new ArrayList<String>();
        if (pkg != null) {
            tok = new StringTokenizer(pkg.getValue(), LIST_SEPARATOR);
            while (tok.hasMoreTokens()) {
                pkgFilters.add(tok.nextToken().trim());
            }
        }
        if (pkgFilters.size() == 0) {
            pkgFilters.add("*");
        }
        tok = new StringTokenizer(entry.getValue(), LIST_SEPARATOR);
        while (tok.hasMoreTokens()) {
            String file = this.parsePath(tok.nextToken(), modelFile);
            data.addAgentEntry(file, pkgFilters);
        }
    }

    private String parsePath(String path, File modelFile) throws IOException {
        if ((path = path.trim()).startsWith("..")) {
            File parent = modelFile.getParentFile().getParentFile();
            boolean checkForLib = path.equals(LIB_PATH);
            path = String.valueOf(parent.getCanonicalPath()) + path.substring(2, path.length());
            if (checkForLib) {
                File fpath = new File(path);
                if (!fpath.exists()) {
                    path = "";
                } else if (fpath.isDirectory()) {
                    String[] files = fpath.list();
                    boolean empty = true;
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        if (!file.endsWith(".txt") && !file.startsWith(".")) {
                            empty = false;
                            break;
                        }
                        ++n2;
                    }
                    if (empty) {
                        path = "";
                    }
                }
            }
        } else if (path.startsWith(".")) {
            File parent = modelFile.getParentFile();
            path = String.valueOf(parent.getCanonicalPath()) + path.substring(1, path.length());
        }
        return path;
    }

    private void processEntry(StartElement elmt, UserPathData data, File modelFile) throws IOException {
        Attribute entry = elmt.getAttributeByName(PATH_A);
        Attribute annotation = elmt.getAttributeByName(ANNOTATION_A);
        boolean process = annotation != null && annotation.getValue().equalsIgnoreCase("true");
        StringTokenizer tok = new StringTokenizer(entry.getValue(), LIST_SEPARATOR);
        while (tok.hasMoreTokens()) {
            String file = this.parsePath(tok.nextToken(), modelFile);
            if (file.length() <= 0) continue;
            data.addEntry(file, process);
        }
    }

    private void processBuiltin(StartElement elmt, UserPathData data, File modelFile) throws IOException {
        Attribute fullname = elmt.getAttributeByName(FULLNAME_A);
        ArrayList<String> pkgFilters = new ArrayList<String>();
        pkgFilters.add(fullname.getValue().trim());
        try {
            URL url = Class.forName(fullname.getValue()).getProtectionDomain().getCodeSource().getLocation();
            String file = url.toURI().getPath();
            data.addAgentEntry(file, pkgFilters);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

