/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.util.ClassPathEntry;

public class UserPathData {
    private String name;
    private List<ClassPathEntry> cpEntries = new ArrayList<ClassPathEntry>();
    private List<ClassPathEntry> annotationCPEntries = new ArrayList<ClassPathEntry>();
    private List<ClassPathEntry> agentCPEntries = new ArrayList<ClassPathEntry>();

    public UserPathData(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addEntry(String entry, boolean processAnnotations) {
        ClassPathEntry cpEntry = new ClassPathEntry(new File(entry));
        this.cpEntries.add(cpEntry);
        if (processAnnotations) {
            this.annotationCPEntries.add(cpEntry);
        }
    }

    public void addAgentEntry(String path, List<String> filters) {
        ClassPathEntry cpEntry = new ClassPathEntry(new File(path), filters);
        this.agentCPEntries.add(cpEntry);
        this.cpEntries.add(cpEntry);
        this.annotationCPEntries.add(cpEntry);
    }

    public int getAgentEntryCount() {
        return this.agentCPEntries.size();
    }

    public Iterable<ClassPathEntry> agentEntries() {
        return this.agentCPEntries;
    }

    public Iterable<ClassPathEntry> classpathEntries() {
        return this.cpEntries;
    }

    public Iterable<ClassPathEntry> annotationCPEntries() {
        return this.annotationCPEntries;
    }
}

