/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import repast.simphony.parameter.StringConverterFactory;
import repast.simphony.scenario.data.Attribute;
import repast.simphony.scenario.data.AttributeFactory;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.ProjectionData;

public class ContextFileWriter {
    public void write(File file, ContextData data) throws IOException {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeContextData(writer, data);
        writer.close();
        if (writer.checkError()) {
            throw new IOException("Error writing context data to file '" + file.getCanonicalPath() + "'");
        }
    }

    private void writeContextData(PrintWriter writer, ContextData data) {
        writer.print("<context id=\"");
        writer.print(data.getId());
        if (data.getContextClassName() != null) {
            writer.print("\" class=\"");
            writer.print(data.getContextClassName());
        }
        writer.println("\">");
        int i = 0;
        while (i < data.getProjectionCount()) {
            ProjectionData proj = data.getProjection(i);
            writer.print("<projection id=\"");
            writer.print(proj.getId());
            writer.print("\" type=\"");
            writer.print(proj.getType());
            if (proj.getAttributeCount() == 0) {
                writer.println("\" />");
            } else {
                writer.println("\" >");
            }
            for (Attribute attrib : proj.attributes()) {
                this.writeAttribute(writer, attrib);
            }
            if (proj.getAttributeCount() > 0) {
                writer.println("</projection>");
            }
            ++i;
        }
        for (Attribute attrib : data.attributes()) {
            this.writeAttribute(writer, attrib);
        }
        for (ContextData child : data.subContexts()) {
            this.writeContextData(writer, child);
        }
        writer.println("</context>");
    }

    private void writeAttribute(PrintWriter writer, Attribute attrib) {
        writer.print("<attribute id=\"");
        writer.print(attrib.getId());
        writer.print("\" value=\"");
        writer.print(attrib.getValue());
        writer.print("\" display_name=\"");
        writer.print(attrib.getDisplayName());
        writer.print("\" type=\"");
        writer.print(AttributeFactory.getTypeName(attrib.getType()));
        if (StringConverterFactory.instance().getConverter(attrib.getType()) == null) {
            writer.print("\" converter=\"");
            writer.print(attrib.getConverter().getClass().getName());
        }
        writer.println("\" />");
    }
}

