/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import repast.simphony.scenario.data.Attribute;
import repast.simphony.scenario.data.AttributeContainer;
import repast.simphony.scenario.data.AttributeFactory;
import repast.simphony.scenario.data.Classpath;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.ContextFileIOConstants;
import repast.simphony.scenario.data.ProjectionData;

public class ContextFileReader {
    private Stack<ContextData> contexts = new Stack();
    private Stack<AttributeContainer> containers = new Stack();
    private ContextData curContext;
    private AttributeContainer curContainer;

    public ContextData read(File file, Classpath contextClasspath) throws IOException, XMLStreamException {
        this.curContext = null;
        this.curContainer = null;
        this.contexts.clear();
        this.containers.clear();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(new BufferedReader(new FileReader(file)));
        while (reader.hasNext()) {
            String qName;
            XMLEvent elmt;
            XMLEvent evt = reader.nextEvent();
            if (evt.isStartElement()) {
                elmt = evt.asStartElement();
                qName = elmt.getName().getLocalPart();
                if (qName.equals("context")) {
                    javax.xml.stream.events.Attribute idA = elmt.getAttributeByName(ContextFileIOConstants.ID_A);
                    javax.xml.stream.events.Attribute classA = elmt.getAttributeByName(ContextFileIOConstants.CLASS_A);
                    ContextData data = classA != null ? new ContextData(idA.getValue(), classA.getValue(), contextClasspath) : new ContextData(idA.getValue(), contextClasspath);
                    if (this.curContext != null) {
                        this.contexts.push(this.curContext);
                    }
                    if (this.curContainer != null) {
                        this.containers.push(this.curContainer);
                    }
                    this.curContext = data;
                    this.curContainer = data;
                    continue;
                }
                if (qName.equals("projection")) {
                    javax.xml.stream.events.Attribute id = elmt.getAttributeByName(ContextFileIOConstants.ID_A);
                    javax.xml.stream.events.Attribute type = elmt.getAttributeByName(ContextFileIOConstants.TYPE_A);
                    String pType = type.getValue();
                    ProjectionData proj = this.curContext.addProjection(id.getValue(), pType);
                    if (this.curContainer != null) {
                        this.containers.push(this.curContainer);
                    }
                    this.curContainer = proj;
                    continue;
                }
                if (!qName.equals("attribute")) continue;
                Attribute attribute = AttributeFactory.parseAttribute((StartElement)elmt);
                this.curContainer.addAttribute(attribute);
                continue;
            }
            if (!evt.isEndElement()) continue;
            elmt = evt.asEndElement();
            qName = elmt.getName().getLocalPart();
            if (qName.equals("context")) {
                if (this.contexts.size() > 0) {
                    ContextData data = this.contexts.pop();
                    data.addSubContext(this.curContext);
                    this.curContext = data;
                }
                if (this.containers.size() <= 0) continue;
                this.curContainer = this.containers.pop();
                continue;
            }
            if (!qName.equals("projection") || this.containers.size() <= 0) continue;
            this.curContainer = this.containers.pop();
        }
        return this.curContext;
    }
}

