/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import repast.simphony.scenario.data.AgentData;
import repast.simphony.scenario.data.AttributeContainer;
import repast.simphony.scenario.data.Classpath;
import repast.simphony.scenario.data.ProjectionData;
import simphony.util.messages.MessageCenter;

public class ContextData
extends AttributeContainer {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(ContextData.class);
    private List<ProjectionData> projections = new ArrayList<ProjectionData>();
    private List<AgentData> agents = new ArrayList<AgentData>();
    private List<ContextData> children = new ArrayList<ContextData>();
    private Classpath classpath;
    private String contextClass;

    public ContextData(String id, Classpath classpath) {
        this(id, null, classpath);
    }

    public ContextData(String id, String contextClassName, Classpath classpath) {
        super(id);
        this.classpath = classpath;
        this.contextClass = contextClassName;
    }

    public String getContextClassName() {
        return this.contextClass;
    }

    public ProjectionData addProjection(String id, String type) {
        ProjectionData proj = new ProjectionData(id, type);
        this.projections.add(proj);
        return proj;
    }

    public void addSubContext(ContextData child) {
        this.children.add(child);
    }

    public Classpath getClasspath() {
        return this.classpath;
    }

    public ContextData find(String contextId) {
        if (contextId.equals(this.id)) {
            return this;
        }
        for (ContextData child : this.children) {
            ContextData data = child.find(contextId);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public void addAgent(String agentClass) {
        AgentData agentData = new AgentData(agentClass);
        this.agents.add(agentData);
    }

    public List<Class<?>> getAgentClasses(boolean includeSubContexts) {
        List<AgentData> allAgents = this.getAgentData(includeSubContexts);
        ArrayList classes = new ArrayList();
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            for (AgentData agent : allAgents) {
                classes.add(Class.forName(agent.getClassName(), false, loader));
            }
        }
        catch (ClassNotFoundException ex) {
            msg.error((Object)"Error while finding agent classes", (Throwable)ex, new Object[0]);
        }
        return classes;
    }

    public List<AgentData> getAgentData(boolean includeSubContexts) {
        HashSet<AgentData> allAgents = new HashSet<AgentData>();
        this.gatherAgents(allAgents, includeSubContexts);
        Iterator it = allAgents.iterator();
        while (it.hasNext()) {
            String simpleName = ((AgentData)it.next()).getShortName();
            if (!simpleName.contains("$") || !simpleName.contains("closure")) continue;
            it.remove();
        }
        return new ArrayList<AgentData>(allAgents);
    }

    private void gatherAgents(Set<AgentData> agents, boolean includeSubContexts) {
        agents.addAll(this.agents);
        if (includeSubContexts) {
            for (ContextData child : this.children) {
                child.gatherAgents(agents, includeSubContexts);
            }
        }
    }

    public List<ContextData> getAllContexts() {
        ArrayList<ContextData> data = new ArrayList<ContextData>();
        this.gatherContexts(data);
        return data;
    }

    private void gatherContexts(List<ContextData> data) {
        data.add(this);
        for (ContextData child : this.children) {
            child.gatherContexts(data);
        }
    }

    public Iterable<ContextData> subContexts() {
        return this.children;
    }

    public int getAgentCount() {
        return this.agents.size();
    }

    public AgentData getAgentData(int index) {
        return this.agents.get(index);
    }

    public int getSubContextCount() {
        return this.children.size();
    }

    public int getProjectionCount() {
        return this.projections.size();
    }

    public ContextData getSubContext(int index) {
        return this.children.get(index);
    }

    public ProjectionData getProjection(int index) {
        return this.projections.get(index);
    }

    public Iterable<ProjectionData> projections() {
        return this.projections;
    }
}

