/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario.data;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterType;
import repast.simphony.parameter.ParameterTypeFactory;
import repast.simphony.parameter.StringConverter;
import repast.simphony.parameter.StringConverterFactory;
import repast.simphony.scenario.data.Attribute;
import repast.simphony.scenario.data.DefaultAttribute;
import simphony.util.messages.MessageCenter;

public class AttributeFactory {
    private static MessageCenter msg = MessageCenter.getMessageCenter(AttributeFactory.class);
    public static Map<String, Class<?>> typeMap = new HashMap();
    private static final QName ID_A;
    private static final QName TYPE_A;
    private static final QName NAME_A;
    private static final QName CONVERTER_A;
    private static final QName VALUE_A;

    static {
        typeMap.put("int", Integer.TYPE);
        typeMap.put("double", Double.TYPE);
        typeMap.put("long", Long.TYPE);
        typeMap.put("float", Float.TYPE);
        typeMap.put("boolean", Boolean.TYPE);
        typeMap.put("byte", Byte.TYPE);
        typeMap.put("short", Short.TYPE);
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
        ID_A = new QName("id");
        TYPE_A = new QName("type");
        NAME_A = new QName("display_name");
        CONVERTER_A = new QName("converter");
        VALUE_A = new QName("value");
    }

    public static String getTypeName(Class<?> type) {
        for (Map.Entry<String, Class<?>> entry : typeMap.entrySet()) {
            if (!entry.getValue().equals(type)) continue;
            return entry.getKey();
        }
        return type.getName();
    }

    public static Attribute parseAttribute(StartElement elmt) {
        DefaultAttribute attribute = new DefaultAttribute();
        javax.xml.stream.events.Attribute xmlA = elmt.getAttributeByName(ID_A);
        attribute.id = xmlA.getValue().trim();
        xmlA = elmt.getAttributeByName(VALUE_A);
        attribute.value = xmlA.getValue();
        xmlA = elmt.getAttributeByName(NAME_A);
        attribute.name = xmlA == null ? attribute.id : xmlA.getValue();
        xmlA = elmt.getAttributeByName(TYPE_A);
        String clazz = xmlA.getValue();
        Class<?> type = typeMap.get(clazz);
        if (type == null) {
            try {
                type = Class.forName(clazz, false, Attribute.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                msg.error((Object)("Error finding type class for attribute '" + attribute.getId() + "'"), (Throwable)ex, new Object[0]);
            }
        }
        attribute.type = type;
        xmlA = elmt.getAttributeByName(CONVERTER_A);
        if (xmlA != null) {
            try {
                Class<?> conClazz = Class.forName(xmlA.getValue(), true, Attribute.class.getClassLoader());
                attribute.converter = (StringConverter)conClazz.newInstance();
            }
            catch (ClassNotFoundException ex) {
                msg.error((Object)("Error creating StringConverter for attribute '" + attribute.getId() + "'"), (Throwable)ex, new Object[0]);
            }
            catch (InstantiationException e) {
                msg.error((Object)("Error creating StringConverter for attribute '" + attribute.getId() + "'"), (Throwable)e, new Object[0]);
            }
            catch (IllegalAccessException e) {
                msg.error((Object)("Error creating StringConverter for attribute '" + attribute.getId() + "'"), (Throwable)e, new Object[0]);
            }
        } else {
            attribute.converter = StringConverterFactory.instance().getConverter(type);
        }
        return attribute;
    }

    public static ParameterType toParameterType(Attribute attrib) {
        ParameterType type = ParameterTypeFactory.instance().getParameterType(attrib.getType());
        if (type == null) {
            type = new PType(attrib.getType(), attrib.getConverter());
        }
        return type;
    }

    public static class PType
    implements ParameterType {
        Class<?> clazz;
        StringConverter conv;

        public PType(Class<?> clazz, StringConverter conv) {
            this.clazz = clazz;
            this.conv = conv;
        }

        public StringConverter getConverter() {
            return this.conv;
        }

        public Class getJavaClass() {
            return this.clazz;
        }

        public Object getValue(String val) throws ParameterFormatException {
            return this.conv.fromString(val);
        }
    }
}

