/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XStream11XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.plugin.ActionExtensions;
import repast.simphony.plugin.ControllerActionIOExtensions;
import repast.simphony.scenario.ControllerActionIO;
import repast.simphony.scenario.FastMethodConvertor;
import repast.simphony.scenario.Scenario;
import repast.simphony.scenario.ScenarioEntry;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.util.collections.Tree;
import simphony.util.messages.MessageCenter;

public class ScenarioSaver {
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(ScenarioSaver.class);
    private ControllerRegistry registry;
    private File scenarioDir;
    private ContextData rootContext;
    private Object currentContextID;
    private ControllerActionIOExtensions ioExts;
    private List<SaverScenarioEntry> entries = new ArrayList<SaverScenarioEntry>();

    public ScenarioSaver(ControllerRegistry registry, File scenarioDir, ContextData rootContext) {
        this.registry = registry;
        this.scenarioDir = scenarioDir;
        this.rootContext = rootContext;
    }

    public void save(ActionExtensions ext, Scenario scenario) throws Exception, ParseErrorException {
        this.ioExts = ext.getIoExts();
        Tree contextGraph = this.registry.getContextIdTree();
        Object contextRoot = contextGraph.getRoot();
        this.saveContext(contextRoot, (Tree<Object>)contextGraph);
        this.saveScenario(scenario.getModelInitName(), scenario.getModelPluginPath());
    }

    private void saveContext(Object contextID, Tree<Object> graph) {
        this.currentContextID = contextID;
        Tree actionGraph = this.registry.getActionTree(contextID);
        ControllerAction rootAction = (ControllerAction)actionGraph.getRoot();
        this.saveAction(rootAction, (Tree<ControllerAction>)actionGraph);
        for (Object subContextID : graph.getChildren(contextID)) {
            this.saveContext(subContextID, graph);
        }
    }

    private void saveAction(ControllerAction action, Tree<ControllerAction> graph) {
        ControllerActionIO io = this.ioExts.getControllerActionIO(action.getClass());
        if (io != null) {
            SaverScenarioEntry entry = new SaverScenarioEntry(action, io, this.createFile(io.getSerializationID()), this.currentContextID);
            this.entries.add(entry);
        }
        for (ControllerAction childAction : graph.getChildren((Object)action)) {
            this.saveAction(childAction, graph);
        }
    }

    private File createFile(String registryID) {
        StringBuffer b = new StringBuffer(registryID);
        b.append("_");
        b.append(this.entries.size());
        b.append(".xml");
        return new File(this.scenarioDir, b.toString());
    }

    private void saveScenario(String modelInitName, File modelPluginPath) throws Exception, ParseErrorException {
        VelocityContext context = new VelocityContext();
        String template = this.getClass().getPackage().getName();
        template = template.replace('.', '/');
        template = String.valueOf(template) + "/Scenario.vt";
        context.put("entries", this.entries);
        if (modelInitName != null && modelInitName.length() > 0) {
            context.put("modelInit", (Object)modelInitName);
        }
        if (modelPluginPath != null) {
            context.put("modelPlugin", (Object)modelPluginPath);
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        xstream.registerConverter((Converter)new FastMethodConvertor(xstream));
        for (SaverScenarioEntry entry : this.entries) {
            try {
                entry.save(xstream);
            }
            catch (Throwable ex) {
                LOG.warn((Object)("Error saving entry '" + entry + "'. Continuing saving."), ex, new Object[0]);
            }
        }
        FileWriter writer = new FileWriter(new File(this.scenarioDir, "scenario.xml"));
        Velocity.mergeTemplate((String)template, (String)"UTF-8", (Context)context, (Writer)writer);
        ((Writer)writer).close();
    }

    class SaverScenarioEntry
    implements ScenarioEntry {
        private File file;
        private Object contextID;
        private ControllerAction action;
        private ControllerActionIO actionIO;

        public SaverScenarioEntry(ControllerAction action, ControllerActionIO actionIO, File file, Object contextID) {
            this.action = action;
            this.actionIO = actionIO;
            this.file = file;
            this.contextID = contextID;
        }

        @Override
        public String getFileName() {
            return this.file.getName();
        }

        @Override
        public String getContextID() {
            return this.contextID.toString();
        }

        @Override
        public String getRegistryID() {
            return this.actionIO.getSerializationID();
        }

        public void save(XStream xstream) throws IOException {
            this.actionIO.getActionSaver().save(xstream, this.action, this.file.getAbsolutePath());
        }

        public String toString() {
            return "id: " + this.getRegistryID() + ", action's class: " + this.action.getClass() + ", action: " + this.action;
        }
    }
}

