/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import repast.simphony.engine.controller.DefaultControllerRegistry;
import repast.simphony.engine.controller.ScheduledMethodControllerAction;
import repast.simphony.engine.controller.WatcherControllerAction;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.ProjectionRegistry;
import repast.simphony.engine.environment.ProjectionRegistryData;
import repast.simphony.engine.environment.RunEnvironmentBuilder;
import repast.simphony.engine.watcher.WatchAnnotationReader;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterType;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.ParametersParser;
import repast.simphony.plugin.ActionExtensions;
import repast.simphony.plugin.ControllerActionIOExtensions;
import repast.simphony.scenario.Scenario;
import repast.simphony.scenario.ScenarioCPInitializer;
import repast.simphony.scenario.ScenarioFileLoader;
import repast.simphony.scenario.ScenarioLoadException;
import repast.simphony.scenario.ScenarioWatcheeInitializer;
import repast.simphony.scenario.data.Attribute;
import repast.simphony.scenario.data.AttributeFactory;
import repast.simphony.scenario.data.Classpath;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.ContextFileReader;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.scenario.data.UserPathData;
import repast.simphony.scenario.data.UserPathFileReader;
import repast.simphony.util.ClassPathEntry;
import simphony.util.messages.MessageCenter;

public class ScenarioLoader {
    private static MessageCenter msg = MessageCenter.getMessageCenter(ScenarioLoader.class);
    private File scenarioDir;
    private Parameters params;
    private ActionExtensions actionExts;
    protected Scenario scenario;

    public ScenarioLoader(File scenarioDir, ActionExtensions actionExts) {
        this.scenarioDir = scenarioDir;
        this.actionExts = actionExts;
    }

    protected void addContextsToRegistry(ControllerRegistry registry, ContextData parent) {
        for (ContextData child : parent.subContexts()) {
            registry.addContextId((Object)parent.getId(), (Object)child.getId());
            this.addContextsToRegistry(registry, child);
        }
    }

    protected void addParentActions(ContextData context, ControllerRegistry registry) {
        this.actionExts.getActionExts().addParentControllerActions(context.getId(), registry);
        for (ContextData child : context.subContexts()) {
            this.addParentActions(child, registry);
        }
    }

    private void addAgentClassNamesToContextData(ContextData context, UserPathData data) {
        try {
            for (ClassPathEntry path : data.agentEntries()) {
                for (String className : path.getClassNames()) {
                    this.addAgentData(className, context);
                }
            }
        }
        catch (IOException ex) {
            msg.warn((Object)"Error while finding agent classes", (Throwable)ex, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            msg.warn((Object)"Error while finding agent classes", (Throwable)ex, new Object[0]);
        }
    }

    private void addAgentData(String className, ContextData context) {
        context.addAgent(className);
        for (ContextData data : context.subContexts()) {
            data.addAgent(className);
        }
    }

    public Parameters getParameters() {
        return this.params;
    }

    public ControllerRegistry load(RunEnvironmentBuilder builder) throws ScenarioLoadException {
        DefaultControllerRegistry registry = null;
        try {
            ParametersParser pp;
            File modelFile = new File(this.scenarioDir, "user_path.xml");
            UserPathData data = new UserPathFileReader().read(modelFile);
            new ScenarioCPInitializer().run(data);
            new ScenarioWatcheeInitializer().run(data);
            Classpath contextClasspath = new Classpath();
            for (ClassPathEntry entry : data.classpathEntries()) {
                boolean added = contextClasspath.addEntry(entry);
                if (added) continue;
                msg.warn((Object)("While initializing classpath: Empty or non-existent path '" + entry.getPath().getCanonicalPath() + "'."), new Object[0]);
            }
            File contextFile = new File(this.scenarioDir, "context.xml");
            ContextData rootContext = new ContextFileReader().read(contextFile, contextClasspath);
            registry = new DefaultControllerRegistry();
            registry.setName(data.getName());
            registry.setMasterContextId((Object)rootContext.getId());
            this.addContextsToRegistry((ControllerRegistry)registry, rootContext);
            Classpath classpath = new Classpath();
            for (ClassPathEntry entry : data.annotationCPEntries()) {
                classpath.addEntry(entry);
            }
            List<Class<?>> annotatedClasses = classpath.getClasses();
            this.createParameters();
            this.addParentActions(rootContext, (ControllerRegistry)registry);
            ControllerAction scheduleRoot = registry.findAction((Object)rootContext.getId(), "repast.controller.action.schedule");
            WatchAnnotationReader watchReader = new WatchAnnotationReader();
            watchReader.processClasses(annotatedClasses);
            if (watchReader.watchCount() > 0) {
                WatcherControllerAction watcherAction = new WatcherControllerAction(watchReader);
                registry.addAction((Object)rootContext.getId(), scheduleRoot, (ControllerAction)watcherAction);
            }
            ScheduledMethodControllerAction action = new ScheduledMethodControllerAction(annotatedClasses);
            registry.addAction((Object)rootContext.getId(), scheduleRoot, (ControllerAction)action);
            this.addAgentClassNamesToContextData(rootContext, data);
            File paramsFile = new File(this.scenarioDir, "parameters.xml");
            if (paramsFile.exists()) {
                pp = new ParametersParser(this.params, paramsFile);
                this.params = pp.getParameters();
            }
            if ((paramsFile = new File(this.scenarioDir, "extended_params.xml")).exists()) {
                pp = new ParametersParser(this.params, paramsFile);
                this.params = pp.getParameters();
            }
            ParametersCreator creator = new ParametersCreator();
            creator.addParameters(this.params);
            this.processContextAttributes(creator, rootContext);
            this.processProjectionAttributes(creator, rootContext);
            this.params = creator.createParameters();
            this.scenario = new Scenario(this.scenarioDir, rootContext, data);
            ScenarioFileLoader loader = new ScenarioFileLoader(this.getIOExts());
            loader.load(this.scenarioDir, this.scenario, (ControllerRegistry)registry);
            this.scenario.setControllerRegistry((ControllerRegistry)registry);
            this.scenario.getModelInitializer().initialize(this.scenario, builder);
            registry.addAction(registry.getMasterContextId(), null, Scenario.DEFAULT_MASTER_PARENT);
            for (ControllerAction masterAction : this.scenario.getMasterControllerActions()) {
                registry.addAction(registry.getMasterContextId(), Scenario.DEFAULT_MASTER_PARENT, masterAction);
            }
            for (ParameterSetter paramSetter : this.scenario.getParameterSetters()) {
                registry.addParameterSetter(paramSetter);
            }
        }
        catch (ClassNotFoundException ex) {
            msg.warn((Object)"Class path not found", (Throwable)ex, new Object[0]);
        }
        catch (Exception ex) {
            throw new ScenarioLoadException(ex.getMessage(), ex);
        }
        return registry;
    }

    private void processContextAttributes(ParametersCreator creator, ContextData context) throws ParameterFormatException {
        for (Attribute attribute : context.attributes()) {
            ParameterType type = AttributeFactory.toParameterType(attribute);
            Object paramVal = type.getValue(attribute.getValue());
            String name = attribute.getId();
            creator.addParameter(name, attribute.getDisplayName(), type.getJavaClass(), paramVal, false);
            creator.addConvertor(name, type.getConverter());
        }
    }

    private void processProjectionAttributes(ParametersCreator creator, ContextData context) throws ParameterFormatException {
        for (ProjectionData proj : context.projections()) {
            for (Attribute attribute : proj.attributes()) {
                if (this.isProjectionAttribute(proj.getType(), attribute.getId())) continue;
                ParameterType type = AttributeFactory.toParameterType(attribute);
                Object paramVal = type.getValue(attribute.getValue());
                String name = String.valueOf(proj.getId()) + attribute.getId();
                creator.addParameter(name, String.valueOf(proj.getId()) + " " + attribute.getDisplayName(), type.getJavaClass(), paramVal, false);
                creator.addConvertor(name, type.getConverter());
            }
        }
        for (ContextData child : context.subContexts()) {
            this.processProjectionAttributes(creator, child);
        }
    }

    private boolean isProjectionAttribute(String type, String attributeId) {
        if (type.equals("network") && attributeId.equals("directed")) {
            return false;
        }
        if (type.equals("grid") && attributeId.equals("allows multi")) {
            return false;
        }
        if ((type.equals("grid") || type.equals("continuous space")) && (attributeId.equals("border rule") || attributeId.equals("width") || attributeId.equals("height"))) {
            return false;
        }
        ProjectionRegistryData data = ProjectionRegistry.getDataFor((String)type);
        return data.isProjectionAttribute(attributeId);
    }

    private void createParameters() throws IOException, ClassNotFoundException, IntrospectionException, ParameterFormatException {
        ParametersCreator creator = new ParametersCreator();
        int val = (int)System.currentTimeMillis();
        if (val < 0) {
            val = Math.abs(val);
        }
        creator.addParameter("randomSeed", "Default Random Seed", Integer.TYPE, null, false);
        this.params = creator.createParameters();
        this.params.setValue("randomSeed", (Object)val);
    }

    protected ControllerActionIOExtensions getIOExts() {
        return this.actionExts.getIoExts();
    }

    public Scenario getScenario() {
        return this.scenario;
    }
}

