/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XStream11XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.plugin.ControllerActionIOExtensions;
import repast.simphony.scenario.ActionLoader;
import repast.simphony.scenario.ControllerActionIO;
import repast.simphony.scenario.FastMethodConvertor;
import repast.simphony.scenario.Scenario;

public class ScenarioFileLoader
extends DefaultHandler2 {
    public static final String MODEL_INITIALIZER_XML = "model.initializer";
    public static final String MODEL_PLUGIN_XML = "model.plugin_jpf";
    private List<ActionLoader> loaders = new ArrayList<ActionLoader>();
    private ControllerActionIOExtensions ext;
    private File scenarioDir;
    private String modelInitClass = null;
    private File modelPluginPath = null;

    public ScenarioFileLoader(ControllerActionIOExtensions ext) {
        this.ext = ext;
    }

    public ControllerRegistry load(File scenarioDir, Scenario scenario, ControllerRegistry registry) throws ParserConfigurationException, SAXException, IOException {
        this.scenarioDir = scenarioDir;
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(new File(scenarioDir, "scenario.xml"), (DefaultHandler)this);
        this.createActions(scenario, registry);
        if (this.modelInitClass != null) {
            scenario.setModelInitName(this.modelInitClass);
        }
        if (this.modelPluginPath != null) {
            scenario.setModelPluginPath(this.modelPluginPath);
        }
        return registry;
    }

    private void createActions(Scenario scenario, ControllerRegistry registry) throws FileNotFoundException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        xstream.registerConverter((Converter)new FastMethodConvertor(xstream));
        for (ActionLoader loader : this.loaders) {
            loader.loadAction(xstream, scenario, registry);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(MODEL_INITIALIZER_XML)) {
            this.modelInitClass = attributes.getValue("class");
        } else if (qName.equals(MODEL_PLUGIN_XML)) {
            String path = attributes.getValue("file").trim();
            if (path.equals("plugin_jpf.xml")) {
                this.modelPluginPath = new File(this.scenarioDir, path);
            }
        } else {
            ControllerActionIO io = this.ext.getControllerActionIO(qName);
            if (io != null) {
                String fileName = attributes.getValue("file");
                String contextID = attributes.getValue("context");
                ActionLoader loader = io.getActionLoader(new File(this.scenarioDir, fileName), contextID);
                this.loaders.add(loader);
            }
        }
    }
}

