/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import repast.simphony.scenario.ScenarioCreatorExtension;
import repast.simphony.scenario.ScenarioEntry;
import repast.simphony.util.FileUtils;
import simphony.util.messages.MessageCenter;

public class ScenarioCreator {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(ScenarioCreator.class);
    private File modelPath;
    private File scenarioPath;
    private String modelInitializerClass;
    private boolean useModelPlugin;
    private List<ScenarioEntry> entries = new ArrayList<ScenarioEntry>();
    private List<ScenarioCreatorExtension> plugins = new ArrayList<ScenarioCreatorExtension>();
    static Set<ScenarioCreatorExtension> extensions = new HashSet<ScenarioCreatorExtension>();

    public static void registerExtension(ScenarioCreatorExtension extension) {
        extensions.add(extension);
    }

    public ScenarioCreator(File modelPath, File scenarioPath) {
        this(modelPath, scenarioPath, null, false);
    }

    public ScenarioCreator(File modelPath, File scenarioPath, String modelInitializerClass) {
        this(modelPath, scenarioPath, modelInitializerClass, false);
    }

    public ScenarioCreator(File modelPath, File scenarioPath, boolean useModelPlugin) {
        this(modelPath, scenarioPath, null, useModelPlugin);
    }

    public ScenarioCreator(File modelPath, File scenarioPath, String modelInitializerClass, boolean useModelPlugin) {
        this.modelInitializerClass = modelInitializerClass;
        this.modelPath = modelPath;
        this.scenarioPath = scenarioPath;
        this.useModelPlugin = useModelPlugin;
        for (ScenarioCreatorExtension extension : extensions) {
            this.addExtension(extension);
        }
    }

    private boolean containsExtensionType(ScenarioCreatorExtension extension) {
        for (ScenarioCreatorExtension strat : this.plugins) {
            if (!extension.getClass().equals(strat.getClass())) continue;
            return true;
        }
        return false;
    }

    public void addExtension(ScenarioCreatorExtension extension) {
        if (!this.containsExtensionType(extension)) {
            this.plugins.add(extension);
        }
    }

    public void createScenario() throws Exception, ParseErrorException {
        this.copyScoreFile();
        this.runExtensions();
        VelocityContext context = new VelocityContext();
        String template = this.getClass().getPackage().getName();
        template = template.replace('.', '/');
        template = String.valueOf(template) + "/Scenario.vt";
        context.put("entries", this.entries);
        if (this.modelInitializerClass != null && this.modelInitializerClass.length() > 0) {
            context.put("modelInit", (Object)this.modelInitializerClass);
        }
        context.put("modelPlugin", (Object)this.useModelPlugin);
        FileWriter writer = new FileWriter(new File(this.scenarioPath, "scenario.xml"));
        Velocity.mergeTemplate((String)template, (String)"UTF-8", (Context)context, (Writer)writer);
        ((Writer)writer).close();
    }

    private void runExtensions() {
        for (ScenarioCreatorExtension extension : this.plugins) {
            try {
                List<ScenarioEntry> entry = extension.run(this.scenarioPath);
                if (entry == null) continue;
                this.entries.addAll(entry);
            }
            catch (Exception ex) {
                msgCenter.error((Object)("Error while running " + extension.getClass().getName()), (Throwable)ex, new Object[0]);
            }
        }
    }

    private void copyScoreFile() throws IOException {
        if (!this.modelPath.getParentFile().equals(this.scenarioPath)) {
            FileUtils.copyFile((File)this.modelPath, (File)new File(this.scenarioPath, "model.score"));
        }
    }
}

