/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.DefaultControllerAction;
import repast.simphony.engine.environment.RunEnvironmentBuilder;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.scenario.ModelInitializer;
import repast.simphony.scenario.ScenarioChangedEvent;
import repast.simphony.scenario.ScenarioChangedListener;
import repast.simphony.scenario.ScenarioUtils;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.UserPathData;

public class Scenario
implements ScenarioChangedListener {
    public static final ControllerAction DEFAULT_MASTER_PARENT = new DefaultControllerAction(){

        public String toString() {
            return "User Specified Actions";
        }
    };
    public static final String SCENARIO_FILE_NAME = "scenario.xml";
    protected File file;
    protected ContextData context;
    protected UserPathData modelData;
    protected List<ParameterSetter> paramSweepers;
    protected List<ControllerAction> masterActions;
    protected ControllerRegistry registry;
    protected String modelInitName;
    protected File modelPluginPath;
    protected boolean dirty = false;

    public Scenario(File file, ContextData context, UserPathData modelData) {
        this.context = context;
        this.modelData = modelData;
        this.setScenarioDirectory(file);
        this.masterActions = new ArrayList<ControllerAction>();
        this.paramSweepers = new ArrayList<ParameterSetter>();
    }

    public ContextData getContext() {
        return this.context;
    }

    public UserPathData getModelData() {
        return this.modelData;
    }

    public ModelInitializer getModelInitializer() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.modelInitName != null && this.modelInitName.length() > 0) {
            Class<?> clazz = Class.forName(this.modelInitName, true, this.getClass().getClassLoader());
            if (!ModelInitializer.class.isAssignableFrom(clazz)) {
                throw new IOException("Class '" + this.modelInitName + "' does not implement the ModelInitializer interface");
            }
            return (ModelInitializer)clazz.newInstance();
        }
        return new ModelInitializer(){

            @Override
            public void initialize(Scenario scen, RunEnvironmentBuilder builder) {
            }
        };
    }

    public File getScenarioDirectory() {
        return this.file;
    }

    public void setScenarioDirectory(File dir) {
        this.file = dir;
        ScenarioUtils.setScenarioDir(dir);
    }

    public void addParameterSetter(ParameterSetter paramInit) {
        this.paramSweepers.add(paramInit);
    }

    public void removeParameterSetter(ParameterSetter paramSetter) {
        this.paramSweepers.remove(paramSetter);
    }

    public Collection<ParameterSetter> getParameterSetters() {
        return Collections.unmodifiableCollection(this.paramSweepers);
    }

    public void addMasterControllerAction(ControllerAction action) {
        this.masterActions.add(action);
    }

    public void removeMasterControllerAction(ControllerAction action) {
        this.masterActions.add(action);
    }

    public Collection<ControllerAction> getMasterControllerActions() {
        return this.masterActions;
    }

    public void setControllerRegistry(ControllerRegistry registry) {
        this.registry = registry;
    }

    public ControllerRegistry getControllerRegistry() {
        return this.registry;
    }

    public String getModelInitName() {
        return this.modelInitName;
    }

    public void setModelInitName(String modelInitName) {
        this.modelInitName = modelInitName;
    }

    public File getModelPluginPath() {
        return this.modelPluginPath;
    }

    public void setModelPluginPath(File modelPluginPath) {
        this.modelPluginPath = modelPluginPath;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void scenarioChanged(ScenarioChangedEvent evt) {
        this.dirty = true;
    }
}

