/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.Reader;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.scenario.AbstractActionLoader;
import repast.simphony.scenario.Scenario;
import simphony.util.messages.MessageCenter;

public abstract class ObjectActionLoader<T>
extends AbstractActionLoader {
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(ObjectActionLoader.class);
    protected Class<T> dataClass;
    protected String actionRoot;

    public ObjectActionLoader(File file, Object contextID, Class<T> dataClass, String actionRoot) {
        super(file, contextID);
        this.dataClass = dataClass;
        this.actionRoot = actionRoot;
    }

    @Override
    protected void performLoad(Reader reader, XStream xstream, Scenario scenario, ControllerRegistry registry) {
        ClassLoader loader = xstream.getClassLoader();
        try {
            try {
                xstream.setClassLoader(this.getClassLoader());
                this.prepare(xstream);
                T descriptor = this.dataClass.cast(xstream.fromXML(reader));
                ControllerAction action = this.createAction(descriptor, scenario);
                ControllerAction parent = registry.findAction(this.contextID, this.actionRoot);
                registry.addAction(this.contextID, parent, action);
            }
            catch (RuntimeException ex) {
                LOG.warn((Object)"Error loading information from data. Continuing with model loading.", (Throwable)ex, new Object[0]);
                if (loader != null) {
                    xstream.setClassLoader(loader);
                }
            }
        }
        finally {
            if (loader != null) {
                xstream.setClassLoader(loader);
            }
        }
    }

    protected void prepare(XStream xstream) {
    }

    protected abstract ControllerAction createAction(T var1, Scenario var2);

    protected abstract ClassLoader getClassLoader();
}

