/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.extended.JavaMethodConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class FastMethodConvertor
implements Converter {
    private JavaMethodConverter jConverter = new JavaMethodConverter(JavaMethodConverter.class.getClassLoader());
    private XStream xstream;

    public FastMethodConvertor(XStream xstream) {
        this.xstream = xstream;
    }

    public boolean canConvert(Class aClass) {
        return aClass != null && aClass.equals(FastMethod.class);
    }

    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        FastMethod fMethod = (FastMethod)o;
        this.jConverter.marshal((Object)fMethod.getJavaMethod(), hierarchicalStreamWriter, marshallingContext);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            reader.moveDown();
            String declaringClassName = reader.getValue();
            Class declaringClass = this.loadClass(declaringClassName);
            reader.moveUp();
            String methodName = null;
            reader.moveDown();
            methodName = reader.getValue();
            reader.moveUp();
            reader.moveDown();
            ArrayList<Class> parameterTypeList = new ArrayList<Class>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String parameterTypeName = reader.getValue();
                parameterTypeList.add(this.loadClass(parameterTypeName));
                reader.moveUp();
            }
            Class[] parameterTypes = parameterTypeList.toArray(new Class[parameterTypeList.size()]);
            reader.moveUp();
            Method method = declaringClass.getDeclaredMethod(methodName, parameterTypes);
            return FastClass.create(method.getDeclaringClass()).getMethod(method);
        }
        catch (ClassNotFoundException e) {
            throw new ConversionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        Class primitiveClass = this.primitiveClassForName(className);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        if (this.xstream != null) {
            return this.xstream.getClassLoader().loadClass(className);
        }
        return this.jConverter.getClass().getClassLoader().loadClass(className);
    }

    private Class primitiveClassForName(String name) {
        return name.equals("void") ? Void.TYPE : (name.equals("boolean") ? Boolean.TYPE : (name.equals("byte") ? Byte.TYPE : (name.equals("char") ? Character.TYPE : (name.equals("short") ? Short.TYPE : (name.equals("int") ? Integer.TYPE : (name.equals("long") ? Long.TYPE : (name.equals("float") ? Float.TYPE : (name.equals("double") ? Double.TYPE : null))))))));
    }
}

