/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.scenario;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.scenario.ActionLoader;
import repast.simphony.scenario.Scenario;
import simphony.util.messages.MessageCenter;

public abstract class AbstractActionLoader
implements ActionLoader {
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(AbstractActionLoader.class);
    protected File file;
    protected Object contextID;

    public AbstractActionLoader(File file, Object contextID) {
        this.file = file;
        this.contextID = contextID;
    }

    @Override
    public void loadAction(XStream xstream, Scenario scenario, ControllerRegistry registry) throws FileNotFoundException {
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(this.file));
                this.performLoad(bufferedReader, xstream, scenario, registry);
            }
            catch (FileNotFoundException ex) {
                LOG.warn((Object)("Error attempting to load file '" + this.file + "'. Not loading the action from that file."), (Throwable)ex, new Object[0]);
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected abstract void performLoad(Reader var1, XStream var2, Scenario var3, ControllerRegistry var4);
}

