/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.java.plugin.JpfException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.StandardPluginLocation;
import saf.core.runtime.PluginDefinitionException;

public class ModelPluginLoader {
    private File path;
    private PluginManager manager;
    private List<String> registeredPlugins = new ArrayList<String>();

    public ModelPluginLoader(PluginManager manager) {
        this.manager = manager;
    }

    public PluginManager getManager() {
        return this.manager;
    }

    public void setPath(File path) {
        this.path = path;
    }

    public String currentPath() {
        return this.path.getAbsolutePath();
    }

    public void removePlugins() {
        for (String id : this.registeredPlugins) {
            this.manager.deactivatePlugin(id);
        }
        String[] ids = new String[this.registeredPlugins.size()];
        this.registeredPlugins.toArray(ids);
        this.manager.getRegistry().unregister(ids);
        this.registeredPlugins.clear();
    }

    public void publishPlugins() throws PluginDefinitionException {
        try {
            StandardPluginLocation location = new StandardPluginLocation(this.path.getParentFile().toURI().toURL(), this.path.toURI().toURL());
            PluginManager.PluginLocation[] pluginLocations = new PluginManager.PluginLocation[]{location};
            Map map = this.manager.publishPlugins(pluginLocations);
            IntegrityCheckReport report = this.manager.getRegistry().checkIntegrity(this.manager.getPathResolver(), true);
            if (report.countErrors() != 0) {
                throw new PluginDefinitionException(this.parsePluginError(report));
            }
            for (PluginDescriptor descriptor : map.values()) {
                this.registeredPlugins.add(descriptor.getId());
            }
        }
        catch (JpfException e) {
            throw new PluginDefinitionException(e.getMessage(), (Throwable)e);
        }
        catch (PluginDefinitionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginDefinitionException(e.getMessage(), (Throwable)e);
        }
    }

    private String parsePluginError(IntegrityCheckReport report) {
        StringBuilder builder = new StringBuilder();
        for (IntegrityCheckReport.ReportItem item : report.getItems()) {
            if (item.getSeverity() != 1) continue;
            builder.append(item.getMessage());
            builder.append("\n");
        }
        return builder.toString();
    }
}

