/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.plugin;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.plugin.CompositeControllerActionCreator;

public class ControllerActionExtensions {
    private List<CompositeControllerActionCreator> parents = new ArrayList<CompositeControllerActionCreator>();

    public void addCompositeActionCreator(CompositeControllerActionCreator creator) {
        this.parents.add(creator);
    }

    public void addParentControllerActions(Object contextID, ControllerRegistry registry) {
        for (CompositeControllerActionCreator composite : this.parents) {
            ControllerAction action;
            if (composite.isMasterOnly()) {
                if (!contextID.equals(registry.getMasterContextId())) continue;
                action = composite.createControllerAction();
                registry.addAction(contextID, null, action);
                registry.registerAction(contextID, composite.getID(), action);
                continue;
            }
            action = composite.createControllerAction();
            registry.addAction(contextID, null, action);
            registry.registerAction(contextID, composite.getID(), action);
        }
    }

    public Iterable<CompositeControllerActionCreator> parentActionCreators() {
        return this.parents;
    }

    public boolean parentsContains(String name) {
        for (CompositeControllerActionCreator creator : this.parents) {
            if (!creator.getClass().getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

