/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.plugin;

import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import repast.simphony.plugin.CompositeControllerActionCreator;
import repast.simphony.plugin.ControllerActionExtensions;
import repast.simphony.plugin.ControllerActionIOExtensions;
import repast.simphony.scenario.ControllerActionIO;
import saf.core.runtime.PluginDefinitionException;

public class ActionExtensions {
    protected ControllerActionExtensions actionExts = new ControllerActionExtensions();
    protected ControllerActionIOExtensions ioExts = new ControllerActionIOExtensions();

    public void loadExtensions(PluginManager manager) throws PluginLifecycleException, PluginDefinitionException {
        this.loadCompositeActions(manager);
        this.loadComponentActions(manager);
    }

    private void loadCompositeActions(PluginManager manager) throws PluginLifecycleException, PluginDefinitionException {
        ExtensionPoint extPoint = manager.getRegistry().getExtensionPoint("repast.simphony.core", "composite.action");
        for (Extension ext : extPoint.getConnectedExtensions()) {
            this.registerActionExt(manager, ext);
        }
    }

    protected void registerActionExt(PluginManager manager, Extension ext) throws PluginLifecycleException, PluginDefinitionException {
        String pluginID = ext.getDeclaringPluginDescriptor().getId();
        manager.activatePlugin(pluginID);
        String className = ext.getParameter("creatorClass").valueAsString();
        if (!this.actionExts.parentsContains(className)) {
            PluginClassLoader pluginClassLoader = manager.getPluginClassLoader(ext.getDeclaringPluginDescriptor());
            try {
                CompositeControllerActionCreator creator = this.instantiate(CompositeControllerActionCreator.class, (ClassLoader)pluginClassLoader, className);
                this.registerActionExt(creator);
            }
            catch (ClassCastException e) {
                throw new PluginDefinitionException("creatorAction class '" + className + "'in '" + pluginID + "' must implement ParentControllerActionCreator", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new PluginDefinitionException("Unable to create class '" + className + "' in composite.action in plugin '" + pluginID + "'", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                throw new PluginDefinitionException("Unable to create class '" + className + "' in composite.action in plugin '" + pluginID + "'", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PluginDefinitionException("Unable to create class '" + className + "' in composite.action in plugin '" + pluginID + "'", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new PluginDefinitionException("Unable to create class '" + className + "' in composite.action in plugin '" + pluginID + "'", (Throwable)e);
            }
        }
    }

    protected <T> T instantiate(Class<T> type, ClassLoader loader, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ClassCastException {
        Class<?> clazz = Class.forName(className, true, loader);
        return type.cast(clazz.newInstance());
    }

    public void registerActionExt(CompositeControllerActionCreator creator) {
        this.actionExts.addCompositeActionCreator(creator);
    }

    protected void registerIoExt(PluginManager manager, Extension ext) throws PluginLifecycleException, PluginDefinitionException {
        String pluginID = ext.getDeclaringPluginDescriptor().getId();
        manager.activatePlugin(pluginID);
        String className = ext.getParameter("actionIO").valueAsString();
        PluginClassLoader pluginClassLoader = manager.getPluginClassLoader(ext.getDeclaringPluginDescriptor());
        try {
            ControllerActionIO io = this.instantiate(ControllerActionIO.class, (ClassLoader)pluginClassLoader, className);
            this.ioExts.addControllerActionIO(io);
        }
        catch (ClassCastException e) {
            throw new PluginDefinitionException("actionIO class '" + className + "'in '" + pluginID + "' must implement ControllerActionIO", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginDefinitionException("Unable to create class '" + className + "' in component.action in plugin '" + pluginID + "'", (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new PluginDefinitionException("Unable to create class '" + className + "' in component.action in plugin '" + pluginID + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginDefinitionException("Unable to create class '" + className + "' in component.action in plugin '" + pluginID + "'", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PluginDefinitionException("Unable to create class '" + className + "' in component.action in plugin '" + pluginID + "'", (Throwable)e);
        }
    }

    public void registerIoExt(ControllerActionIO io) {
        this.ioExts.addControllerActionIO(io);
    }

    private void loadComponentActions(PluginManager manager) throws PluginLifecycleException, PluginDefinitionException {
        ExtensionPoint extPoint = manager.getRegistry().getExtensionPoint("repast.simphony.core", "component.action");
        for (Extension ext : extPoint.getConnectedExtensions()) {
            this.registerIoExt(manager, ext);
        }
    }

    public ControllerActionExtensions getActionExts() {
        return this.actionExts;
    }

    public ControllerActionIOExtensions getIoExts() {
        return this.ioExts;
    }
}

