/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.runtime;

import java.io.File;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.BasicConfigurator;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import repast.simphony.runtime.RepastMain;
import saf.core.runtime.Boot;
import simphony.util.messages.MessageCenter;

public class RepastBatchMain {
    static MessageCenter msgCenter = MessageCenter.getMessageCenter(RepastBatchMain.class);
    private Options options = new Options();

    public RepastBatchMain() {
        Option help = new Option("help", "print this message");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given parameter sweep file");
        Option paramfile = OptionBuilder.create((String)"params");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"use optimizable parameter sweeper with given optimizing properties file");
        Option opt = OptionBuilder.create((String)"opt");
        OptionBuilder.withDescription((String)"specifies if the batch mode is interactive");
        Option mode = OptionBuilder.create((String)"interactive");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"location of boot.properties file (optional)");
        Option bootProps = OptionBuilder.create((String)"bootprops");
        this.options.addOption(help);
        this.options.addOption(paramfile);
        this.options.addOption(opt);
        this.options.addOption(mode);
        this.options.addOption(bootProps);
    }

    public void run(String[] args) {
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(this.options, args);
            if (line.hasOption("help") || args.length < 1) {
                this.showHelp();
                System.exit(0);
            }
            String[] bootArgs = new String[]{"", ""};
            if (line.hasOption("bootprops")) {
                bootArgs[1] = line.getOptionValue("bootprops");
            } else {
                URL runtimeSource = RepastMain.class.getProtectionDomain().getCodeSource().getLocation();
                String path = runtimeSource.getFile().replaceAll("%20", " ");
                bootArgs[1] = String.valueOf(new File(path).getParent()) + File.separator;
            }
            Boot boot = new Boot();
            PluginManager manager = boot.init(bootArgs);
            if (manager == null) {
                BasicConfigurator.configure();
                throw new IllegalArgumentException("Unable to load the repast symphony libraries. Is the boot.properties path '" + bootArgs[1] + "' correct?");
            }
            Plugin plugin = manager.getPlugin("repast.simphony.core");
            PluginClassLoader loader = manager.getPluginClassLoader(plugin.getDescriptor());
            Class<?> clazz = Class.forName("repast.simphony.batch.BatchInit", true, (ClassLoader)loader);
            Object init = clazz.newInstance();
            clazz.getMethod("run", CommandLine.class, String[].class).invoke(init, line, args);
        }
        catch (Exception ex) {
            this.showHelp();
            msgCenter.fatal((Object)"Fatal error starting repast.simphony simphony.", (Throwable)ex, new Object[0]);
            ex.printStackTrace();
        }
    }

    private void showHelp() {
        HelpFormatter formatter = new HelpFormatter();
        String header = "Where target is the path to a scenario file or the fully qualified name of a class that implements repast.simphony.batch.BatchScenarioCreator.\n";
        formatter.printHelp(String.valueOf(RepastMain.class.getName()) + " [options] target", header, this.options, "");
    }

    public static void main(String[] args) {
        new RepastBatchMain().run(args);
    }
}

