/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.StandardPluginClassLoader;

public class ExtendablePluginClassLoader
extends StandardPluginClassLoader {
    private Set<PluginDescriptor> descriptors = new HashSet<PluginDescriptor>();
    private Set<String> addedPaths = new HashSet<String>();

    public ExtendablePluginClassLoader(PluginManager aManager, PluginDescriptor descr, ClassLoader parent) {
        super(aManager, descr, parent);
        this.descriptors.add(descr);
        this.collectImports();
        this.resourceLoader = ExtendablePluginClassLoader.getResourceLoader(aManager, this.descriptors);
        this.collectFilters();
        this.libraryCache = new HashMap();
    }

    public void addDescriptor(PluginDescriptor descriptor) {
        if (!this.descriptors.contains(descriptor)) {
            this.descriptors.add(descriptor);
            URL[] newUrls = ExtendablePluginClassLoader.getUrls((PluginManager)this.getPluginManager(), (PluginDescriptor)descriptor, (URL[])this.getURLs());
            int i = 0;
            while (i < newUrls.length) {
                this.addURL(newUrls[i]);
                ++i;
            }
            this.collectImports();
            this.resourceLoader = ExtendablePluginClassLoader.getResourceLoader(this.getPluginManager(), this.descriptors);
            this.collectFilters();
            Iterator it = this.libraryCache.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue() != null) continue;
                it.remove();
            }
            ArrayList<PluginDescriptor> descsToAdd = new ArrayList<PluginDescriptor>();
            for (PluginPrerequisite pre : descriptor.getPrerequisites()) {
                if (!pre.matches()) continue;
                PluginDescriptor preDescr = this.getPluginDescriptor().getRegistry().getPluginDescriptor(pre.getPluginId());
                descsToAdd.add(preDescr);
            }
            for (PluginDescriptor pd : descsToAdd) {
                this.addDescriptor(pd);
            }
        }
    }

    protected void collectFilters() {
        if (this.resourceFilters == null) {
            this.resourceFilters = new HashMap();
        } else {
            this.resourceFilters.clear();
        }
        for (PluginDescriptor descriptor : this.descriptors) {
            for (Library lib : descriptor.getLibraries()) {
                this.resourceFilters.put(this.getPluginManager().getPathResolver().resolvePath((Identity)lib, lib.getPath()), new StandardPluginClassLoader.ResourceFilter(lib));
            }
        }
    }

    public void appendPaths(String paths) throws IOException {
        StringTokenizer tok = new StringTokenizer(paths, ";", false);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (this.addedPaths.contains(path)) continue;
            URL url = new File(path).getCanonicalFile().toURL();
            this.addURL(url);
            this.resourceLoader.addURL(url);
            this.addedPaths.add(path);
        }
    }

    protected void collectImports() {
        if (this.descriptors == null) {
            this.descriptors = new HashSet<PluginDescriptor>();
        }
        HashMap<String, PluginDescriptor> publicImportsMap = new HashMap<String, PluginDescriptor>();
        HashMap<String, PluginDescriptor> privateImportsMap = new HashMap<String, PluginDescriptor>();
        PluginRegistry registry = this.getPluginDescriptor().getRegistry();
        for (PluginDescriptor descriptor : this.descriptors) {
            for (PluginPrerequisite pre : descriptor.getPrerequisites()) {
                if (!pre.matches()) continue;
                PluginDescriptor preDescr = registry.getPluginDescriptor(pre.getPluginId());
                if (pre.isExported()) {
                    publicImportsMap.put(preDescr.getId(), preDescr);
                    continue;
                }
                privateImportsMap.put(preDescr.getId(), preDescr);
            }
        }
        this.publicImports = publicImportsMap.values().toArray(new PluginDescriptor[publicImportsMap.size()]);
        this.privateImports = privateImportsMap.values().toArray(new PluginDescriptor[privateImportsMap.size()]);
        HashMap<String, PluginDescriptor> reverseLookupsMap = new HashMap<String, PluginDescriptor>();
        block2: for (PluginDescriptor descr : registry.getPluginDescriptors()) {
            if (descr.equals(this.getPluginDescriptor()) || publicImportsMap.containsKey(descr.getId()) || privateImportsMap.containsKey(descr.getId())) continue;
            for (PluginPrerequisite pre : descr.getPrerequisites()) {
                if (!pre.getPluginId().equals(this.getPluginDescriptor().getId()) || !pre.isReverseLookup() || !pre.matches()) continue;
                reverseLookupsMap.put(descr.getId(), descr);
                continue block2;
            }
        }
        this.reverseLookups = reverseLookupsMap.values().toArray(new PluginDescriptor[reverseLookupsMap.size()]);
    }

    private static StandardPluginClassLoader.PluginResourceLoader getResourceLoader(PluginManager manager, Set<PluginDescriptor> descriptors) {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (PluginDescriptor descriptor : descriptors) {
            for (Library lib : descriptor.getLibraries()) {
                if (lib.isCodeLibrary()) continue;
                urls.add(manager.getPathResolver().resolvePath((Identity)lib, lib.getPath()));
            }
        }
        if (urls.isEmpty()) {
            return null;
        }
        return new StandardPluginClassLoader.PluginResourceLoader(urls.toArray(new URL[urls.size()]));
    }
}

