/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.styles;

import java.io.File;
import java.io.IOException;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import repast.simphony.relogo.styles.ReLogoSpatialSource;
import repast.simphony.visualizationOGL2D.SVGSpatialSource;

public class ReLogoSVGSpatialSource
extends SVGSpatialSource
implements ReLogoSpatialSource {
    private static final String SIMPLE = "simple";
    private static final String ROTATE = "rotate";
    private static final String OFFSET = "offset ";
    private boolean rotate;
    private float offset;

    public ReLogoSVGSpatialSource(String id, String path) throws IOException {
        super(id, path);
    }

    @Override
    public boolean doRotate() {
        return this.rotate;
    }

    @Override
    public float getOffset() {
        return this.offset;
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    protected void parseProps(String path) throws IOException {
        String uri;
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        SVGOMDocument doc = (SVGOMDocument)f.createDocument(uri = new File(path).toURI().toString());
        NodeList nodes = doc.getElementsByTagName("dc:subject");
        if (nodes.getLength() > 0) {
            nodes = ((Element)nodes.item(0)).getElementsByTagName("rdf:li");
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i).getNodeType() == 1) {
                    Element item = (Element)nodes.item(i);
                    this.parseProperty(item.getTextContent().trim());
                }
                ++i;
            }
        }
    }

    private void parseProperty(String text) throws IOException {
        if (text.equals(SIMPLE)) {
            this.simple = true;
        } else if (text.equals(ROTATE)) {
            this.rotate = true;
        } else if (text.startsWith(OFFSET)) {
            try {
                this.offset = Float.parseFloat(text.substring(OFFSET.length()));
            }
            catch (NumberFormatException ex) {
                throw new IOException("Invalid offset");
            }
        }
    }
}

