/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.styles;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ListIterator;
import org.piccolo2d.PNode;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.util.PBounds;
import simphony.util.messages.MessageCenter;

public class BoundingPPath
extends PPath.Double {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(BoundingPPath.class);
    public static final String CHANGE_COLOR = "CHANGE_COLOR";

    public BoundingPPath(Rectangle2D shape) {
        super((Shape)shape, null);
    }

    public void setPaint(Paint newPaint) {
        ListIterator li = this.getChildrenIterator();
        while (li.hasNext()) {
            PNode child = (PNode)li.next();
            if (!child.getBooleanAttribute((Object)CHANGE_COLOR, false)) continue;
            if (child instanceof PPath && ((PPath)child).getStroke() != null) {
                ((PPath)child).setStrokePaint(newPaint);
            }
            child.setPaint(newPaint);
        }
    }

    public boolean setBounds(Rectangle2D arg0) {
        double newWidth = arg0.getWidth();
        double newHeight = arg0.getHeight();
        PBounds oldBounds = this.getBounds();
        double oldWidth = oldBounds.getWidth();
        double oldHeight = oldBounds.getHeight();
        double widthRatio = newWidth / oldWidth;
        double heightRatio = newHeight / oldHeight;
        boolean returnBoolean = super.setBounds(arg0);
        ListIterator li = this.getChildrenIterator();
        while (li.hasNext()) {
            PNode child = (PNode)li.next();
            child.setTransform(AffineTransform.getScaleInstance(widthRatio, heightRatio));
        }
        return returnBoolean;
    }
}

