/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.factories;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.relogo.BasePatch;
import repast.simphony.relogo.DiffusiblePatchVariable;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.Patch;
import simphony.util.messages.MessageCenter;

public class PatchFactory {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(PatchFactory.class);
    private Observer observer = null;
    private Class<? extends BasePatch> patchType;

    public PatchFactory(Class<? extends BasePatch> patchType) {
        if (!BasePatch.class.isAssignableFrom(patchType)) {
            throw new RuntimeException("Argument to PatchFactoryImpl constructor needs to extend BasePatch.");
        }
        this.patchType = patchType;
    }

    public void init(Observer observer) {
        this.observer = observer;
        try {
            Class<? extends BasePatch> pType = this.patchType;
            ArrayList<DiffusiblePatchVariable> createdVars = new ArrayList<DiffusiblePatchVariable>();
            do {
                Method getDiffusiblePatchVarsMethod;
                Object result;
                if ((result = (getDiffusiblePatchVarsMethod = pType.getMethod("getDiffusiblePatchVars", new Class[0])).invoke(null, new Object[0])) == null || !(result instanceof List)) continue;
                List patchVars = (List)result;
                for (Object var : patchVars) {
                    DiffusiblePatchVariable svar;
                    if (!(var instanceof DiffusiblePatchVariable) || createdVars.contains(svar = (DiffusiblePatchVariable)var)) continue;
                    observer.createPatchVar(svar);
                    createdVars.add(svar);
                }
            } while (!(pType = pType.getSuperclass()).equals(BasePatch.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Patch createPatch() {
        if (this.observer == null) {
            throw new RuntimeException("The PatchFactoryImpl init method needs to be called before instatiating Patches.");
        }
        BasePatch patch = null;
        try {
            patch = this.patchType.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        patch.setBasePatchProperties(this.observer, this);
        return patch;
    }
}

